% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{paste_blocks}
\alias{paste_blocks}
\title{Paste a list of blocks into a single block}
\usage{
paste_blocks(blocks, sep = "_", nested_metadata = NULL)
}
\arguments{
\item{blocks}{Blocks, either a single data.frame or a list of
data.frames}

\item{sep}{String to use as separator for output pasted values}

\item{nested_metadata}{A Boolean indicating the existence of nested metadata
in the \code{blockmeasures} list, e.g. as is typically
output by \code{read_blocks}. If NULL, will attempt to
infer existence of nested metadata}
}
\value{
If nested_metadata = TRUE (or is inferred to be TRUE), a list
        containing a list containing: 1. a \code{data.frame} with the
        pasted data values from \code{blocks}, and 2. a vector with the 
        pasted metadata values from \code{blocks}
        
        If nested_metadata = FALSE (or is inferred to be FALSE), a list
        containing \code{data.frame}'s with the pasted values from
        \code{blocks}
}
\description{
This function uses \code{paste} to concatenate the same-location entries
of a list of data.frames together (i.e. all the first row-first column
values are pasted together, all the second row-first column values are
pasted together, etc.)
}
