% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{MovingWindowFunctions}
\alias{MovingWindowFunctions}
\alias{moving_average}
\alias{moving_median}
\title{Moving window smoothing}
\usage{
moving_average(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  window_width_n = NULL,
  window_width = NULL,
  window_width_n_frac = NULL,
  window_width_frac = NULL,
  na.rm = TRUE,
  warn_nonnumeric_sort = TRUE
)

moving_median(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  window_width_n = NULL,
  window_width = NULL,
  window_width_n_frac = NULL,
  window_width_frac = NULL,
  na.rm = TRUE,
  warn_nonnumeric_sort = TRUE
)
}
\arguments{
\item{formula}{Formula specifying the numeric response (density) 
and numeric predictor (time).}

\item{data}{Dataframe containing variables in \code{formula}}

\item{x}{A vector of predictor values to smooth along (e.g. time)}

\item{y}{A vector of response values to be smoothed (e.g. density).}

\item{window_width_n}{Number of data points wide the moving window is
(therefore, must be an odd number of points)}

\item{window_width}{Width of the moving window (in units of \code{x})}

\item{window_width_n_frac}{Width of the window (as a fraction of the total
number of data points).}

\item{window_width_frac}{Width of the window (as a fraction of the range of
\code{x})}

\item{na.rm}{logical whether NA's should be removed before analyzing}

\item{warn_nonnumeric_sort}{logical whether warning should be issued when 
predictor variable that data is sorted by is 
non-numeric.}
}
\value{
Vector of smoothed data, with NA's appended at both ends
}
\description{
These functions use a moving window to smooth data
}
\details{
Either \code{x} and \code{y} or \code{formula} and \code{data}
         must be provided.
         
         Values of \code{NULL} or \code{NA} will be ignored for any of
         \code{window_width_n}, \code{window_width},
         \code{window_width_n_frac}, or \code{window_width_frac}
}
