% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{reduce_time.array}
\alias{reduce_time.array}
\title{Apply a function over time and bands in a four-dimensional (band, time, y, x) array}
\usage{
\method{reduce_time}{array}(x, FUN, ...)
}
\arguments{
\item{x}{four-dimensional input array with dimensions band, time, y, x (in this order)}

\item{FUN}{function which receives one time series in a two-dimensional array with dimensions bands, time as input}

\item{...}{further arguments passed to FUN}
}
\description{
Apply a function over time and bands in a four-dimensional (band, time, y, x) array
}
\details{
FUN is expected to produce a numeric vector (or scalar) where elements are interpreted as new bands in the result.
}
\note{
This is a helper function that uses the same dimension ordering as gdalcubes streaming. It can be used to simplify 
the application of R functions e.g. over time series in a data cube.
}
\examples{
d <- c(4,16,32,32)
x <- array(rnorm(prod(d)), d)
# reduce individual bands over pixel time series
y <- reduce_time(x, function(v) {
  apply(v, 1, mean)
})
dim(y)
}
