% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection.R
\name{print.image_collection}
\alias{print.image_collection}
\title{Print image collection information}
\usage{
\method{print}{image_collection}(x, ..., n = 6)
}
\arguments{
\item{x}{Object of class "image_collection"}

\item{...}{Further arguments passed to the generic print function}

\item{n}{Number of images for which details are printed}
}
\description{
Prints information about images in an image collection.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
print(L8.col)
}
