% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_simplify}
\alias{g_simplify}
\title{Simplify WKB/WKT geometries optionally preserving topology}
\usage{
g_simplify(
  geom,
  tolerance,
  preserve_topology = TRUE,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{tolerance}{Numeric value of the simplification tolerance, as distance
in units of the input \code{geom}. Simplification removes vertices which are
within the tolerance distance of the simplified linework (as long as
topology is preserved when \code{preserve_topology = TRUE}).}

\item{preserve_topology}{Logical value, \code{TRUE} to simplify geometries while
preserving topology (the default). Setting to \code{FALSE} simplifies geometries
using the standard Douglas-Peucker algorithm which is significantly faster
(see Details).}

\item{as_wkb}{Logical value, \code{TRUE} to return the output geometry in WKB
format (the default), or \code{FALSE} to return as WKT.}

\item{as_iso}{Logical value, \code{TRUE} to export as ISO WKB/WKT (ISO 13249
SQL/MM Part 3), or \code{FALSE} (the default) to export as "Extended WKB/WKT".}

\item{byte_order}{Character string specifying the byte order when output is
WKB. One of \code{"LSB"} (the default) or \code{"MSB"} (uncommon).}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
A polygon as WKB raw vector or WKT string, or a list/character vector of
polygons as WKB/WKT with length equal to the number of input geometries.
\code{NA} is returned with a warning if WKB input cannot be converted into an
OGR geometry object, or if an error occurs in the call to the underlying
OGR API.
}
\description{
\code{g_simplify()} computes a simplified geometry. By default, it simplifies
the input geometries while preserving topology (see Details). Wrapper of
\code{OGR_G_Simplify()} / \code{OGR_G_SimplifyPreserveTopology()} in the GDAL API
(GEOS via GDAL headers).
}
\details{
Definitions of these operations are given in the GEOS documentation
(\url{https://libgeos.org/doxygen/}), which are copied here
(GEOS 3.14.0dev).

With \code{preserve_topology = TRUE} (the default):\cr
Simplifies a geometry, ensuring that the result is a valid geometry having
the same dimension and number of components as the input. The simplification
uses a maximum distance difference algorithm similar to the one used in the
Douglas-Peucker algorithm. In particular, if the input is an areal geometry
(Polygon or MultiPolygon), the result has the same number of shells and
holes (rings) as the input, in the same order. The result rings touch at no
more than the number of touching point in the input (although they may touch
at fewer points).

With \code{preserve_topology = FALSE}:\cr
Simplifies a geometry using the standard Douglas-Peucker algorithm. Ensures
that any polygonal geometries returned are valid. Simple lines are not
guaranteed to remain simple after simplification. Note that in general D-P
does not preserve topology - e.g. polygons can be split, collapse to lines
or disappear, holes can be created or disappear, and lines can cross. To
simplify geometry while preserving topology use TopologyPreservingSimplifier.
(However, using D-P is significantly faster).
}
\note{
\code{preserve_topology = TRUE} does not preserve boundaries shared between
polygons.
}
\examples{
g <- "LINESTRING(0 0,1 1,10 0)"
g_simplify(g, tolerance = 5, as_wkb = FALSE)
}
