% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_get_actual_url}
\alias{vsi_get_actual_url}
\title{Returns the actual URL of a supplied VSI filename}
\usage{
vsi_get_actual_url(filename)
}
\arguments{
\item{filename}{Character string containing a /vsiPREFIX/ filename.}
}
\value{
Character string containing the actual URL, or \code{NULL} if
\code{filename} is not a network-based virtual file system.
}
\description{
\code{vsi_get_actual_url()} returns the actual URL of a supplied filename.
Currently only returns a non-NULL value for network-based virtual file
systems. For example "/vsis3/bucket/filename" will be expanded as
"https://bucket.s3.amazon.com/filename".
Wrapper for \code{VSIGetActualURL()} in the GDAL API.
}
\examples{
\dontrun{
f <- "/vsiaz/items/io-lulc-9-class.parquet"
set_config_option("AZURE_STORAGE_ACCOUNT", "pcstacitems")
# token obtained from:
# https://planetarycomputer.microsoft.com/api/sas/v1/token/pcstacitems/items
set_config_option("AZURE_STORAGE_SAS_TOKEN","<token>")
vsi_get_actual_url(f)
#> [1] "https://pcstacitems.blob.core.windows.net/items/io-lulc-9-class.parquet"
vsi_get_signed_url(f)
#> [1] "https://pcstacitems.blob.core.windows.net/items/io-lulc-9-class.parquet?<token>"
}
}
\seealso{
\code{\link[=vsi_get_signed_url]{vsi_get_signed_url()}}
}
