% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesu_opgd.R
\name{sesu_opgd}
\alias{sesu_opgd}
\title{comparison of size effects of spatial units based on OPGD}
\usage{
sesu_opgd(
  formula,
  datalist,
  su,
  discvar,
  discnum = 3:8,
  discmethod = c("sd", "equal", "geometric", "quantile", "natural"),
  cores = 1,
  increase_rate = 0.05,
  alpha = 0.95,
  ...
)
}
\arguments{
\item{formula}{A formula of comparison of size effects of spatial units.}

\item{datalist}{A list of \code{data.frame} or \code{tibble}.}

\item{su}{A vector of sizes of spatial units.}

\item{discvar}{Name of continuous variable columns that need to be discretized.Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns.}

\item{discnum}{(optional) A vector of number of classes for discretization. Default is \code{3:8}.}

\item{discmethod}{(optional) A vector of methods for discretization, default is using
\code{c("sd","equal","geometric","quantile","natural")} by invoking \code{sdsfun}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{increase_rate}{(optional) The critical increase rate of the number of discretization.
Default is \verb{5\%}.}

\item{alpha}{(optional) Specifies the size of confidence level. Default is \code{0.95}.}

\item{...}{(optional) Other arguments passed to \code{gd_bestunidisc()}.}
}
\value{
A list.
\describe{
\item{\code{sesu}}{a tibble representing size effects of spatial units}
\item{\code{optsu}}{optimal spatial unit}
\item{\code{increase_rate}}{the critical increase rate of q value}
}
}
\description{
Function for comparison of size effects of spatial units in spatial heterogeneity analysis based on
optimal parameters geographical detector(OPGD) model.
}
\details{
Firstly, the \code{OPGD} model is executed for each data in the datalist (all \code{significant}
Q statistic of each data are averaged to represent the spatial association strength under
this spatial unit), and then the \code{loess_optscale} function is used to select the optimal
spatial analysis scale.
}
\examples{
\dontrun{
## The following code takes a long time to run:
library(tidyverse)
fvcpath = "https://github.com/SpatLyu/rdevdata/raw/main/FVC.tif"
fvc = terra::rast(paste0("/vsicurl/",fvcpath))
fvc1000 = fvc \%>\%
  terra::as.data.frame(na.rm = T) \%>\%
  as_tibble()
fvc5000 = fvc \%>\%
  terra::aggregate(fact = 5) \%>\%
  terra::as.data.frame(na.rm = T) \%>\%
  as_tibble()
sesu_opgd(fvc ~ .,
          datalist = list(fvc1000,fvc5000),
          su = c(1000,5000),
          discvar = names(select(fvc5000,-c(fvc,lulc))),
          cores = 6)
}
}
\references{
Song, Y., Wang, J., Ge, Y. & Xu, C. (2020) An optimal parameters-based geographical detector
model enhances geographic characteristics of explanatory variables for spatial heterogeneity
analysis: Cases with different types of spatial data, GIScience & Remote Sensing, 57(5), 593-610.
doi: 10.1080/15481603.2020.1760434.
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
