% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.geolm_cmodStd.R
\name{estimate.geolm_cmodStd}
\alias{estimate.geolm_cmodStd}
\title{Determine MLEs of model parameters for a geostatistical
model}
\usage{
\method{estimate}{geolm_cmodStd}(
  object,
  reml = FALSE,
  noise_type = "e",
  lower = NULL,
  upper = NULL,
  method = "nlminb",
  itnmax = NULL,
  control = list(),
  est_nugget = TRUE,
  est_par3 = TRUE,
  est_angle = FALSE,
  est_ratio = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A geostatistical linear model object
produced by the \code{geolm} function.}

\item{reml}{A logical value indicating whether standard
maximum likelihood estimation should be performed
(\code{reml = FALSE}).  If \code{reml = TRUE}, then the
restricted maximum likelihood is performed.  The
default is \code{FALSE}.}

\item{noise_type}{A character vector indicating the type
of noise (nugget) variance to estimate. The default is
\code{est = "e"}, indicating the error variance should
be estimated. Alternatively, the user can specify
\code{est = "f"}, indicating that the finescale
variance should be estimated. The other type of noise
variance is set to 0, otherwise the model is not
identifiable. See Details.}

\item{lower}{A named list with the names of the
parameters you wish to set lower bounds for and the
associated value. See Details.}

\item{upper}{A named list with the names of the
parameters you wish to set upper bounds for and the
associated value.}

\item{method}{The optimization method.  The default is
\code{"nlminb"}, with \code{"L-BFGS-B"} being another
acceptable choice.  See \code{\link[optimx]{optimx}}
for details.}

\item{itnmax}{An integer indicating the maximum number of
iterations to allow for the optimization procedure.}

\item{control}{A list of control parameters passed
internally to \code{\link[optimx]{optimx}}.}

\item{est_nugget}{A logical value indicating whether the
nugget variance (\code{evar} or \code{fvar}) should be
estimated. The default is \code{TRUE}, indicating that
the nugget should be estimated.}

\item{est_par3}{A logical value indicating whether
\code{par3} should be estimated (for an appropriate
covariance model such as \code{"matern"} or
\code{"amatern"}. The default is \code{TRUE},
indicating that this parameter should be estimated.}

\item{est_angle}{A logical value indicating whether the
geometric anisotropy angle should be estimated. The
default is \code{FALSE}, indicating that this parameter
should not be estimated.}

\item{est_ratio}{A logical value indicating whether the
geometric anisotropy ratio of minor axis length to
major axis length should be estimated. The default is
\code{FALSE}, indicating that this parameter should not
be estimated.}

\item{verbose}{A logical value indicating whether
potentially informative messages should be printed. The
default is \code{FALSE}.}

\item{...}{Currently unimplemented}
}
\description{
\code{estimate} estimates the parameters of a
geostatistical linear model of class \code{geolm_cmodStd}
using maximum likelihood estimation.
}
\details{
The \code{\link[optimx]{optimx}} function is used to find
the MLEs.  The \code{control} argument of
\code{\link[optimx]{optimx}} has a parameter \code{kkt}
related to checking optimality conditions. This is
internally set to \code{FALSE}.  See
\code{\link[optimx]{optimx}} for Details.

Only the sum of \code{evar} and \code{fvar} is
identifiable. Depending on the choice of
\code{noise_type}, the covariance model is internally
updated to estimate only one type of noise. e.g., if
\code{noise_type = "e"}, then internally we update
\code{evar} so that \code{evar = evar + fvar} and
\code{fvar = 0}. Estimation is then performed on
\code{evar} alone. Alternatively, the analagous estimated
would be made for \code{fvar} if \code{noise_type =
"fvar"}.

When \code{est_nugget} is true, the likelihood is
profiled to simplify the optimization problem. In that
case a parameter \code{lambda = (evar + fvar)/psill} is
optimized. The optimal \code{psill} and noise variance
are then determined.

The \code{lower} argument should be a named list with the
names of the parameters you wish to set lower bounds for.
If not specified, an attempt is made to specify
reasonable lower bounds. The current choices are \code{r
= 0.001}, \code{psill = 0.001}, \code{lambda = 0},
\code{angle = 0}, \code{ratio = 0.001}, \code{par3 =
0.001}.

The \code{upper} argument should be a named list with the
names of the parameters you wish to set upper bounds for.
If not specified, an attempt is made to specify
reasonable upper bounds. The current choices are \code{r
= 5 * } maximum intercentroid distance, \code{psill = 5 *
var(object$y)}, \code{lambda = 5}, \code{angle = 179.99},
\code{ratio = 1}, \code{par3 = 3}.
}
\examples{
data(toydata, package = "gear")
# setup standard covariance model
mod_std = cmod_std("exponential", psill = 1, r = 1, evar = 0.1)
# setup  dataframe with data
# fit Std geolm
object = geolm(y ~ x1 + x2, data = toydata, mod = mod_std,
                  coordnames = c("x1", "x2"))
est_object = estimate(object, control = list(trace = 1),
                      verbose = TRUE)
}
\seealso{
\code{\link[gear]{cmod_std}},
  \code{\link[optimx]{optimx}}
}
\author{
Joshua French
}
