\name{ordgee}
\alias{ordgee}
\title{GEE for Clustered Ordinal Responses}
\description{
  Produces an object of class `geese' which is a Generalized Estimating
  Equation fit of the clustered ordinal data.
}
\usage{
ordgee(formula = formula(data), ooffset = NULL, id, waves = NULL,
       data = parent.frame, subset = NULL, na.action = na.omit,
       contrasts = NULL, weights = NULL, z = NULL,
       mean.link = "logit", corstr = "independence",
       control = geese.control(...), b = NA, alpha = NA,
       scale.fix = FALSE, scale.val = 1, int.const = TRUE,
       rev = FALSE,...)
}
\arguments{
  \item{formula}{a formula expression as for \code{glm}, of the form
    \code{response ~ predictors}. See the documentation of lm and
    formula for details. As for glm, this specifies the linear predictor
    for modelling the mean. A term of the form \code{offset(expression)}
    is allowed.
  }
  \item{ooffset}{vector of offset for the odds ratio model.}
  \item{id}{a vector which identifies the clusters.  The length of `id'
    should be the same as the number of observations.  Data are assumed
    to be sorted so that observations on a cluster are contiguous rows
    for all entities in the formula.}
  \item{waves}{an integer vector which identifies components in
    clusters. The length of \code{waves} should be the same as the
    number of observation. components with the same \code{waves} value
    will have the same link functions. }
  \item{data}{
        an optional data frame in which to interpret the variables occurring
    in the \code{formula}, along with the \code{id} and \code{n} variables.
  }
  \item{subset}{
    expression saying which subset of the rows of the data should be used
    in the fit.  This can be a logical vector (which is replicated to have
    length equal to the number of observations), or a numeric vector
    indicating which observation numbers are to be included, or a
    character vector of the row names to be included.
    All observations are included by default.
  }
  \item{na.action}{
    a function to filter missing data.  For \code{gee} only \code{na.omit}
    should be used here.
  }
  \item{contrasts}{
    a list giving contrasts for some or all of the factors appearing
    in the model formula.  The elements of the list should have the
    same name as the variable and should be either a contrast matrix
    (specifically, any full-rank matrix with as many rows as there are
    levels in the factor), or else a function to compute such a matrix
    given the number of levels.
  }
  \item{weights}{an optional vector of weights to be used
    in the fitting process. The length of \code{weights} should be the
    same as the number of observations.
  }
  \item{z}{a design matrix for the odds ratio model. The number of rows
    of z is \deqn{c^2 \sum n_i(n_i - 1)/2,} where \eqn{n_i} is the cluster
    size, and \eqn{c} is the number of categories minus 1.
  }
  \item{mean.link}{a character string specifying the link function for
    the means. The following are allowed:
    \code{"logit"}, \code{"probit"}, and \code{"cloglog"}.
  }
  \item{corstr}{a character string specifying the log odds. The
    following are allowed:
    \code{"independence"}, \code{"exchangeable"}, \code{"unstructured"},
    and \code{"userdefined"}.
  }
  \item{control}{a list of iteration and algorithmic constants. See
    \code{\link{geese.control}} for their names and default
    values. These can also be set as arguments to \code{geese} itself.
  }
  \item{b}{an initial estimate for the mean parameters.}
  \item{alpha}{an initial estimate for the odds ratio parameters.}
  \item{scale.fix}{a logical variable indicating if scale is fixed; it
    is set at TRUE currently.}
  \item{scale.val}{this argument is ignored currently.}
  \item{int.const}{a logical variable; if true, the intercepts are
    constant, and if false, the intercepts are different for different
    components in the response.}
  \item{rev}{a logical variable. For example, for a three level ordered
    response Y = 2, the accumulated indicator is coded as (1, 0, 0) if
    true and (0, 1, 1) if false.}
  \item{\dots}{further arguments passed to or from other methods.}
}
\value{
  An object of class \code{"geese"} representing the fit.
}
\references{
  Heagerty, P.J. and Zeger, S.L. (1996)
  Marginal regression models for clustered ordinal measurements.
  \emph{JASA}, \bold{91} 1024--1036.
}
\author{Jun Yan \email{jyan@stat.uiowa.edu}}
\seealso{
  \code{\link{glm}}, \code{\link{lm}}, \code{\link{geese}}.
}
\examples{
data(respdis)
resp.l <- reshape(respdis, varying =list(c("y1", "y2", "y3", "y4")),
                  v.names = "resp", direction = "long")
resp.l <- resp.l[order(resp.l$id, resp.l$time),]
fit <- ordgee(resp ~ trt, id=id, data=resp.l, int.const=FALSE)
summary(fit)

data(ohio)
ohio$resp <- as.factor(ohio$resp)
fit <- ordgee(resp ~ age + smoke + age:smoke, id = id, data=ohio)
summary(fit)
}
\keyword{nonlinear}
\keyword{models}
