% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsoid.R
\name{ellipsoid}
\alias{ellipsoid}
\title{Calculate an ellipsoid in 3D}
\usage{
ellipsoid(center, shape, radius = 1, segments = 60, warn.rank = FALSE)
}
\arguments{
\item{center}{A vector of length 3 giving the center of the 3D ellipsoid,
typically the mean vector of a data matrix.}

\item{shape}{A 3 x 3 matrix giving the shape of the 3D ellipsoid, typical a
covariance matrix of a data matrix.}

\item{radius}{radius of the ellipsoid, with default \code{radius=1}, giving
a standard ellipsoid. For a multivariate sample with \code{dfe} degrees of
freedom associated with \code{shape}, an ellipsoid of \code{level} coverage
can be calculated using \code{radius=sqrt(3 * qf(level, 3, dfe))}.}

\item{segments}{number of line segments to use in each direction in the
wire-frame representation of the ellipsoid}

\item{warn.rank}{warn if the \code{shape} matrix is of rank < 3?}
}
\value{
A qmesh3d object
}
\description{
Calculates a \code{\link[rgl]{qmesh3d}} object representing a 3D ellipsoid
with given \code{center} and \code{shape} matrix.  The function allows for
degenerate ellipsoids where the \code{shape} matrix has rank < 3 and plots
as an ellipse or a line.
}
\details{
The ellipsoid is calculated by transforming a unit sphere by the Cholesky
square root of the \code{shape} matrix, and translating to the
\code{center}.

The ellipsoid can be plotted with \code{plot3d}
}
\examples{
## none yet


}
\author{
Michael Friendly and John Fox, extending Duncan Murdoch
}
\keyword{dplot}
