% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.klr}
\alias{gelnet.klr}
\title{Kernel logistic regression}
\usage{
gelnet.klr(K, y, lambda, max.iter = 100, eps = 1e-05, v.init = rep(0,
  nrow(K)), b.init = 0.5, silent = FALSE)
}
\arguments{
\item{K}{n-by-n matrix of pairwise kernel values over a set of n samples}

\item{y}{n-by-1 vector of binary response labels}

\item{lambda}{scalar, regularization parameter}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{v.init}{initial parameter estimate for the kernel weights}

\item{b.init}{initial parameter estimate for the bias term}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}
}
\value{
A list with two elements:
\describe{
  \item{v}{n-by-1 vector of kernel weights}
  \item{b}{scalar, bias term for the model}
}
}
\description{
Learns a kernel logistic regression model for a binary classification task
}
\details{
The method operates by constructing iteratively re-weighted least squares approximations
of the log-likelihood loss function and then calling the kernel ridge regression routine
to solve those approximations. The least squares approximations are obtained via the Taylor series
expansion about the current parameter estimates.
}
\seealso{
\code{\link{gelnet.krr}}, \code{\link{gelnet.logreg}}
}

