\name{gemmFitRcppI}
\alias{gemmFitRcppI}
\title{gemmFitRcppI}
\usage{
  gemmFitRcppI(n, betas, data, p, kCor, correction, isTauB)
}
\arguments{
  \item{n}{integer, number of observations in dataset.}

  \item{betas}{numeric matrix of random weights.}

  \item{data}{numeric matrix, dataset constructed based on original
  \code{\link{gemm.formula}} call. First column is criterion variable.}

  \item{p}{integer, number of potential predictors in data.}

  \item{kCor}{numeric vector, penalty term for given vector of weights. Will
  always equal number of non-zero weights unless interactions are included.}
  
  \item{correction}{character string, names correction to \code{tau} for BIC
  calculation. Currently set as "\code{knp}".}

  \item{isTauB}{boolean to set BIC computation based on tau-a or tau-b.}
}
\value{
  \item{fit}{list of named vectors for BICtau, BICr, tau, and r.}
}
\description{
  This function is run each generation to calculate fit between weighted
  predictors and response based on \code{fit.metric}, (weights generated by
  \code{\link{genAlg}}), and criterion. Calls a number of Rcpp functions that
  are hidden from R.
}
\seealso{
  \code{\link{gemm}} for full model-fitting function, \code{\link{tauTest}} for
  quick Kendall's \code{tau}.
}
