/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.SingleParameterChanger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class FiniteUpdate
implements MCMCUpdate {
    MCMCParameter param;
    int[] numvalues;
    private int whoseTurn = 0;
    private int numTurns;
    MCMCBond[] bonds;
    private int[] whatami;
    static Random rand = new Random(System.currentTimeMillis());
    int[] acceptances;
    SingleParameterChanger paramchanger;

    public FiniteUpdate(MCMCParameter param, int numvalues) {
        this(param, new int[]{numvalues});
    }

    public FiniteUpdate(MCMCParameter param, int[] numvalues) {
        this.param = param;
        this.numvalues = numvalues;
        this.numTurns = param.length();
        this.acceptances = new int[this.numTurns];
        for (int i = 0; i < this.numTurns; ++i) {
            this.acceptances[i] = 0;
        }
        this.bonds = param.relevantBonds();
        this.whatami = new int[this.bonds.length];
        System.arraycopy(param.whatami, 0, this.whatami, 0, this.bonds.length);
    }

    public void update() {
        while (this.whoseTurn < this.numTurns) {
            if (!this.param.areConstant(this.whoseTurn)) {
                double[] candprob = this.candidate();
                double samp = rand.nextDouble();
                int k = 0;
                while (samp > candprob[k]) {
                    ++k;
                }
                if ((int)this.param.getValue()[this.whoseTurn] != k) {
                    int n = this.whoseTurn;
                    this.acceptances[n] = this.acceptances[n] + 1;
                }
                this.param.setValue(this.whoseTurn, k);
                for (int j = 0; j < this.bonds.length; ++j) {
                    this.bonds[j].blank_value();
                }
            }
            ++this.whoseTurn;
        }
        this.whoseTurn = 0;
    }

    public double[] candidate() {
        int i;
        int num = this.numvalues[this.whoseTurn];
        double[] probs = new double[num];
        for (int i2 = 0; i2 < num; ++i2) {
            probs[i2] = 0.0;
            for (int j = 0; j < this.bonds.length; ++j) {
                int n = i2;
                probs[n] = probs[n] + this.bonds[j].compute(this.whatami[j], i2, this.whoseTurn);
            }
            probs[i2] = Math.exp(probs[i2]);
        }
        double summ = 0.0;
        for (i = 0; i < probs.length; ++i) {
            summ += probs[i];
        }
        i = 0;
        while (i < probs.length) {
            int n = i++;
            probs[n] = probs[n] / summ;
        }
        for (i = 1; i < probs.length; ++i) {
            int n = i;
            probs[n] = probs[n] + probs[i - 1];
        }
        return probs;
    }

    public MCMCBond[] relevantBonds() {
        return this.bonds;
    }

    public void ignoreBond(MCMCBond ignorable) {
        HashSet<MCMCBond> bondset = new HashSet<MCMCBond>();
        for (int j = 0; j < this.bonds.length; ++j) {
            bondset.add(this.bonds[j]);
        }
        boolean removed = bondset.remove(ignorable);
        if (!removed) {
            return;
        }
        this.bonds = new MCMCBond[bondset.size()];
        int k = 0;
        Iterator iter = bondset.iterator();
        while (iter.hasNext()) {
            this.bonds[k++] = (MCMCBond)iter.next();
        }
    }

    public String accepted() {
        String ac = "";
        for (int i = 0; i < this.acceptances.length; ++i) {
            ac = ac + i + ":" + this.acceptances[i] + " ";
        }
        return ac;
    }

    public void updateoutput() {
    }

    public void finish() {
    }
}

