/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.JumpPerturber;
import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class LogitPerturber
implements JumpPerturber,
TunablePerturber {
    int which;
    double[] mss;
    double scale = 1.0;
    double adj = 1.0;
    static Random rand = new Random(System.currentTimeMillis());

    public LogitPerturber(int which, double[] mss) {
        this.which = which;
        this.mss = mss;
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        this.scale = Math.exp(this.mss[whoseTurn] * rand.nextGaussian());
        double temp = 1.0 / (1.0 + this.scale * (1.0 - candarray[this.which][whoseTurn]) / candarray[this.which][whoseTurn]);
        this.adj = temp * (1.0 - temp) / candarray[this.which][whoseTurn] / (1.0 - candarray[this.which][whoseTurn]);
        candarray[this.which][whoseTurn] = temp;
    }

    public int numTurns() {
        return this.mss.length;
    }

    public double jacobian() {
        return this.adj;
    }

    public double density(double[][] oldarr, double[][] newarr, int whoseTurn) {
        double temp = oldarr[this.which][whoseTurn];
        temp = Math.log(temp / (1.0 - temp));
        double temp1 = newarr[this.which][whoseTurn];
        temp1 = Math.log(temp1 / (1.0 - temp1));
        return 1.0 / Math.sqrt(Math.PI * 2) / this.mss[whoseTurn] * Math.exp(-(temp - temp1) * (temp - temp1) / 2.0 / this.mss[whoseTurn] / this.mss[whoseTurn]) / newarr[this.which][whoseTurn] / (1.0 - newarr[this.which][whoseTurn]);
    }

    public double[] getStepSizes() {
        double[] tem = new double[this.mss.length];
        System.arraycopy(this.mss, 0, tem, 0, this.mss.length);
        return tem;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        System.arraycopy(s, 0, this.mss, 0, s.length);
    }
}

