/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCNode;
import gov.lanl.yadas.MCMCOutput;
import gov.lanl.yadas.TunableMCMCUpdate;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Random;

public class MCMCParameter
implements MCMCNode,
TunableMCMCUpdate,
MCMCOutput {
    public static final int MAX_BONDS = 100;
    protected double[] value;
    double[] proposedvalue;
    double[] probvalue;
    private boolean firstupdateoutput = true;
    public int whoseTurn = 0;
    double candidate;
    MCMCBond[] bonds;
    MCMCBond[] bondss;
    boolean bondscomputed = false;
    public int[] whatami;
    int numbonds;
    public double[] MetropolisStepSize;
    boolean isConstant;
    boolean hasOutput;
    String name;
    public static Random rand = new Random(System.currentTimeMillis());
    PrintWriter out;
    PrintWriter propose_out;
    PrintWriter prob_out;
    public NumberFormat nf;
    public NumberFormat probnf;
    int[] accs;
    boolean firsttuneoutput = true;
    PrintWriter tune_out;
    public NumberFormat nft;

    public MCMCParameter(double[] v, double[] mss, String name) {
        int i;
        this.hasOutput = name != null;
        this.value = v;
        this.proposedvalue = new double[v.length];
        this.probvalue = new double[v.length];
        for (i = 0; i < v.length; ++i) {
            this.proposedvalue[i] = -1.0;
            this.probvalue[i] = -1.0;
        }
        this.bonds = new MCMCBond[100];
        this.whatami = new int[100];
        this.numbonds = 0;
        this.MetropolisStepSize = new double[mss.length];
        System.arraycopy(mss, 0, this.MetropolisStepSize, 0, mss.length);
        for (i = 0; i < mss.length && mss[i] == 0.0; ++i) {
        }
        if (i < mss.length) {
            this.isConstant = false;
            try {
                if (this.hasOutput) {
                    this.out = new PrintWriter(new FileWriter(name + ".out"));
                }
            }
            catch (IOException e) {
                System.out.print("Error: " + e);
                System.exit(1);
            }
        } else {
            this.isConstant = true;
        }
        this.name = name;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
        this.probnf = NumberFormat.getNumberInstance();
        this.probnf.setMaximumFractionDigits(3);
        this.probnf.setGroupingUsed(false);
        this.nft = NumberFormat.getNumberInstance();
        this.nft.setMaximumFractionDigits(3);
        this.nft.setGroupingUsed(false);
        this.accs = new int[v.length];
        for (int ii = 0; ii < this.accs.length; ++ii) {
            this.accs[ii] = 0;
        }
    }

    public void update() {
        if (this.isConstant) {
            return;
        }
        while (this.whoseTurn < this.value.length) {
            double ap;
            this.proposedvalue[this.whoseTurn] = this.candidate = this.candidate()[0];
            this.probvalue[this.whoseTurn] = ap = this.acceptanceProbability();
            if (ap > (double)rand.nextFloat()) {
                this.takeStep();
            }
            ++this.whoseTurn;
        }
        this.whoseTurn = 0;
    }

    public double[] candidate() {
        double[] temp = new double[]{this.value[this.whoseTurn] + rand.nextGaussian() * this.MetropolisStepSize[this.whoseTurn]};
        return temp;
    }

    public MCMCBond[] relevantBonds() {
        if (this.bondscomputed) {
            return this.bondss;
        }
        this.bondss = new MCMCBond[this.numbonds];
        System.arraycopy(this.bonds, 0, this.bondss, 0, this.numbonds);
        this.bondscomputed = true;
        return this.bondss;
    }

    public double acceptanceProbability() {
        double lr = 0.0;
        MCMCBond[] baunds = this.relevantBonds();
        for (int j = 0; j < baunds.length; ++j) {
            lr += baunds[j].compute(this.whatami[j], this.candidate, this.whoseTurn);
        }
        return Math.exp(lr);
    }

    public void takeStep() {
        this.value[this.whoseTurn] = this.candidate;
        MCMCBond[] baunds = this.relevantBonds();
        for (int j = 0; j < baunds.length; ++j) {
            baunds[j].revise();
        }
        int n = this.whoseTurn;
        this.accs[n] = this.accs[n] + 1;
    }

    public String toString() {
        String out = "";
        for (int i = 0; i < this.value.length - 1; ++i) {
            out = out + this.nf.format(this.value[i]) + "|";
        }
        out = out + this.nf.format(this.value[this.value.length - 1]);
        return out;
    }

    public String toStringTune() {
        String out = "";
        double[] temp = this.getStepSizes();
        for (int i = 0; i < temp.length - 1; ++i) {
            out = out + this.nft.format(temp[i]) + "|";
        }
        out = out + this.nft.format(temp[temp.length - 1]);
        return out;
    }

    public String toStringPropose() {
        String out = "";
        for (int i = 0; i < this.proposedvalue.length - 1; ++i) {
            out = out + this.nf.format(this.proposedvalue[i]) + "|";
        }
        out = out + this.nf.format(this.proposedvalue[this.proposedvalue.length - 1]);
        return out;
    }

    public String toStringProb() {
        String out = "";
        for (int i = 0; i < this.probvalue.length - 1; ++i) {
            out = out + this.nf.format(this.probvalue[i]) + "|";
        }
        out = out + this.nf.format(this.probvalue[this.probvalue.length - 1]);
        return out;
    }

    public void output() {
        if (!this.isConstant && this.hasOutput) {
            this.out.println(this.toString());
        }
    }

    public void updateoutput() {
        if (this.firstupdateoutput && this.hasOutput) {
            this.firstupdateoutput = false;
            try {
                this.propose_out = new PrintWriter(new FileWriter(this.name + "_propose.out"));
                this.prob_out = new PrintWriter(new FileWriter(this.name + "_prob.out"));
            }
            catch (IOException e) {
                System.out.print("Error: " + e);
                System.exit(1);
            }
        }
        if (!this.isConstant && this.hasOutput) {
            this.propose_out.println(this.toStringPropose());
            this.prob_out.println(this.toStringProb());
        }
    }

    public void tuneoutput() {
        if (!this.isConstant && this.hasOutput) {
            if (this.firsttuneoutput) {
                this.firsttuneoutput = false;
                try {
                    this.tune_out = new PrintWriter(new FileWriter(this.name + ".tun"));
                }
                catch (IOException e) {
                    System.out.print("Error: " + e);
                    System.exit(1);
                }
            }
            this.tune_out.println(this.toStringTune());
        }
    }

    public boolean sample_exact() {
        return false;
    }

    public double getValue(int i) {
        return this.value[i];
    }

    public double[] getValue() {
        double[] temp = new double[this.value.length];
        System.arraycopy(this.value, 0, temp, 0, this.value.length);
        return temp;
    }

    public void setValue(double[] newvalue) {
        System.arraycopy(newvalue, 0, this.value, 0, this.value.length);
    }

    public void setValue(int which, double newvalue) {
        this.value[which] = newvalue;
    }

    public double[] getStepSizes() {
        double[] cpy = new double[this.MetropolisStepSize.length];
        System.arraycopy(this.MetropolisStepSize, 0, cpy, 0, this.MetropolisStepSize.length);
        return cpy;
    }

    public void setStepSize(double s, int i) {
        if (!this.isConstant) {
            this.MetropolisStepSize[i] = s;
        }
    }

    public void setStepSizes(double[] s) {
        if (!this.isConstant) {
            for (int i = 0; i < this.MetropolisStepSize.length; ++i) {
                this.MetropolisStepSize[i] = s[i];
            }
        }
    }

    static void printints(int[] vec) {
        String op = "";
        for (int i = 0; i < vec.length; ++i) {
            op = op + vec[i] + " ";
        }
        System.out.println(op);
    }

    public void addBond(MCMCBond bond, int which) {
        if (this.numbonds < 100) {
            this.bonds[this.numbonds] = bond;
            this.whatami[this.numbonds] = which;
            ++this.numbonds;
        }
    }

    public void finish() {
        if (!this.isConstant && this.hasOutput) {
            this.out.close();
            if (!this.firstupdateoutput) {
                this.propose_out.close();
                this.prob_out.close();
            }
            if (!this.firsttuneoutput) {
                this.tune_out.close();
            }
        }
    }

    public int length() {
        return this.value.length;
    }

    public static void main() {
        System.out.println("Testing MCMCParameter.class\n");
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean areConstant(int i) {
        return this.MetropolisStepSize[i] == 0.0;
    }

    public String accepted() {
        String ac = "";
        for (int i = 0; i < this.accs.length; ++i) {
            ac = ac + i + ":" + this.accs[i] + " ";
        }
        return ac;
    }

    public int[] acceptances() {
        return this.accs;
    }

    public String getName() {
        return this.name;
    }
}

