/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.Tools;
import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class SumPreservingPerturber
implements TunablePerturber {
    private int numrvs;
    private int[][] stepindex;
    private int[][] rvindex;
    private double[] mss;
    static Random rand = new Random(System.currentTimeMillis());

    public SumPreservingPerturber(MCMCParameter[] params, double[] mss) {
        int d;
        this.numrvs = d = params.length;
        this.stepindex = new int[d][];
        this.rvindex = new int[d][];
        for (int i = 0; i < d; ++i) {
            int ni = params[i].length();
            this.stepindex[i] = new int[ni];
            this.rvindex[i] = new int[ni];
            for (int j = 0; j < ni; ++j) {
                this.stepindex[i][j] = 0;
                this.rvindex[i][j] = i;
            }
        }
        this.mss = mss;
    }

    public SumPreservingPerturber(int numrvs, int[][] stepindex, int[][] rvindex, double[] mss) {
        this.numrvs = numrvs;
        this.stepindex = stepindex;
        this.rvindex = rvindex;
        this.mss = mss;
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        double[] normals = new double[this.numrvs];
        for (int i = 0; i < this.numrvs; ++i) {
            normals[i] = this.mss[whoseTurn] * rand.nextGaussian();
        }
        double temp = Tools.mean(normals);
        int i = 0;
        while (i < this.numrvs) {
            int n = i++;
            normals[n] = normals[n] - temp;
        }
        for (int j = 0; j < candarray.length; ++j) {
            for (int k = 0; k < candarray[j].length; ++k) {
                if (this.stepindex[j][k] != whoseTurn) continue;
                double[] dArray = candarray[j];
                int n = k;
                dArray[n] = dArray[n] + normals[this.rvindex[j][k]];
            }
        }
    }

    public int numTurns() {
        return this.mss.length;
    }

    public double jacobian() {
        return 1.0;
    }

    public double[] getStepSizes() {
        return this.mss;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        this.mss = s;
    }
}

