/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.stat;

import org.drugis.common.stat.DichotomousDescriptives;
import org.drugis.common.stat.EstimateWithPrecision;

public class Statistics {
    private Statistics() {
    }

    public static double logit(double p) {
        return Math.log(p) - Math.log(1.0 - p);
    }

    public static double ilogit(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static EstimateWithPrecision logOddsRatio(int a, int n, int c, int m, boolean corrected) {
        DichotomousDescriptives desc = new DichotomousDescriptives(corrected);
        return new EstimateWithPrecision(desc.logOddsRatio(a, n, c, m), desc.logOddsRatioError(a, n, c, m));
    }

    public static EstimateWithPrecision meanDifference(double m0, double s0, double n0, double m1, double s1, double n1) {
        double md = m1 - m0;
        double se = Math.sqrt(s0 * s0 / n0 + s1 * s1 / n1);
        return new EstimateWithPrecision(md, se);
    }
}

