/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.SetHypergraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.drugis.mtc.graph.GraphUtil;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.TreatmentComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkModel {
    public static Hypergraph<Treatment, Study> createStudyGraph(Network network) {
        SetHypergraph<Treatment, Study> graph = new SetHypergraph<Treatment, Study>();
        for (Treatment t : network.getTreatments()) {
            graph.addVertex(t);
        }
        for (Study s : network.getStudies()) {
            graph.addEdge(s, (Collection<Treatment>)s.getTreatments());
        }
        return graph;
    }

    public static UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> createComparisonGraph(Network network) {
        return NetworkModel.createComparisonGraph(NetworkModel.createStudyGraph(network));
    }

    public static UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> createComparisonGraph(Hypergraph<Treatment, Study> studyGraph) {
        UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> graph = FoldingTransformerFixed.foldHypergraphEdges(studyGraph, UndirectedSparseGraph.getFactory());
        NetworkModel.standardizeEdgeVertexOrder(graph);
        return graph;
    }

    private static void standardizeEdgeVertexOrder(UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> graph) {
        for (FoldingTransformerFixed.FoldedEdge edge : new ArrayList(graph.getEdges())) {
            ArrayList vertices = new ArrayList(graph.getIncidentVertices(edge));
            Collections.sort(vertices, new TreatmentComparator());
            graph.removeEdge(edge);
            FoldingTransformerFixed.FoldedEdge edge2 = new FoldingTransformerFixed.FoldedEdge((Treatment)vertices.get(0), (Treatment)vertices.get(1));
            edge2.getFolded().addAll(edge.getFolded());
            graph.addEdge(edge2, vertices);
        }
    }

    public static DirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> toDirected(UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> ug) {
        DirectedSparseGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> dg = new DirectedSparseGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>>();
        GraphUtil.addVertices(dg, ug.getVertices());
        for (FoldingTransformerFixed.FoldedEdge edge : ug.getEdges()) {
            Treatment t0 = (Treatment)edge.getVertices().getFirst();
            Treatment t1 = (Treatment)edge.getVertices().getSecond();
            dg.addEdge((FoldingTransformerFixed.FoldedEdge<Treatment, Study>)edge, t0, t1);
            FoldingTransformerFixed.FoldedEdge edge1 = new FoldingTransformerFixed.FoldedEdge(t1, t0);
            edge1.getFolded().addAll(edge.getFolded());
            dg.addEdge(edge1, t1, t0);
        }
        return dg;
    }

    public static Measurement findMeasurement(Study study, final Treatment treatment) {
        return CollectionUtils.find(study.getMeasurements(), new Predicate<Measurement>(){

            @Override
            public boolean evaluate(Measurement m) {
                return m.getTreatment().equals(treatment);
            }
        });
    }

    public static List<Treatment> getTreatments(Study study) {
        ArrayList<Treatment> treatments = new ArrayList<Treatment>(study.getTreatments());
        Collections.sort(treatments, TreatmentComparator.INSTANCE);
        return treatments;
    }

    public static <O> List<O> transformTreatmentPairs(Network network, Transformer<Pair<Treatment>, ? extends O> transformer) {
        int n = network.getTreatments().size();
        ArrayList<O> list = new ArrayList<O>();
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                Treatment ti = (Treatment)network.getTreatments().get(i);
                Treatment tj = (Treatment)network.getTreatments().get(j);
                list.add(transformer.transform(new Pair<Treatment>(ti, tj)));
                ++j;
            }
            ++i;
        }
        return list;
    }
}

