/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import edu.uci.ics.jung.graph.util.Pair;
import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Binomial;
import gov.lanl.yadas.ConstantArgument;
import gov.lanl.yadas.Gaussian;
import gov.lanl.yadas.GroupArgument;
import gov.lanl.yadas.IdentityArgument;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.Uniform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.drugis.mtc.MCMCSettings;
import org.drugis.mtc.MixedTreatmentComparison;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.AbstractDataStartingValueGenerator;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.InconsistencyParameter;
import org.drugis.mtc.parameterization.InconsistencyParameterization;
import org.drugis.mtc.parameterization.InconsistencyStandardDeviation;
import org.drugis.mtc.parameterization.InconsistencyStartingValueGenerator;
import org.drugis.mtc.parameterization.NetworkModel;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.Parameterization;
import org.drugis.mtc.parameterization.PriorGenerator;
import org.drugis.mtc.parameterization.RandomEffectsStandardDeviation;
import org.drugis.mtc.parameterization.SplitParameter;
import org.drugis.mtc.parameterization.StartingValueGenerator;
import org.drugis.mtc.yadas.AbstractYadasModel;
import org.drugis.mtc.yadas.Derivation;
import org.drugis.mtc.yadas.MultivariateGaussian;
import org.drugis.mtc.yadas.ParameterWriter;
import org.drugis.mtc.yadas.RelativeEffectArgumentMaker;
import org.drugis.mtc.yadas.SigmaRowArgumentMaker;
import org.drugis.mtc.yadas.SuccessProbabilityArgumentMaker;
import org.drugis.mtc.yadas.ThetaArgumentMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class YadasModel
extends AbstractYadasModel
implements MixedTreatmentComparison {
    protected final Network d_network;
    protected Parameterization d_pmtz = null;
    private PriorGenerator d_priorGen;
    private List<StartingValueGenerator> d_startGen = new ArrayList<StartingValueGenerator>();
    private Parameter d_randomEffectsStdDev = new RandomEffectsStandardDeviation();
    protected Parameter d_inconsistencyStdDev = new InconsistencyStandardDeviation();
    private List<Parameter> d_parameters;

    public YadasModel(Network network, MCMCSettings settings) {
        super(settings);
        this.d_network = network;
    }

    protected YadasModel(Network network, Parameterization pmtz, MCMCSettings settings) {
        this(network, settings);
        this.d_pmtz = pmtz;
    }

    protected abstract boolean isInconsistency();

    @Override
    public BasicParameter getRelativeEffect(Treatment base, Treatment subj) {
        return new BasicParameter(base, subj);
    }

    @Override
    public Parameter getRandomEffectsStandardDeviation() {
        return this.d_randomEffectsStdDev;
    }

    private double getStartingSigma(StartingValueGenerator startVal) {
        return 1.0E-5 + Math.random() * (this.d_priorGen.getRandomEffectsSigma() - 1.0E-5);
    }

    private double getStartingValue(StartingValueGenerator startVal, NetworkParameter p, double[] basicStart) {
        if (p instanceof BasicParameter) {
            return startVal.getRelativeEffect((BasicParameter)p);
        }
        if (p instanceof SplitParameter) {
            SplitParameter sp = (SplitParameter)p;
            BasicParameter bp = new BasicParameter(sp.getBaseline(), sp.getSubject());
            return startVal.getRelativeEffect(bp);
        }
        if (p instanceof InconsistencyParameter) {
            HashMap<BasicParameter, Double> basicValues = new HashMap<BasicParameter, Double>();
            List<NetworkParameter> parameters = this.d_pmtz.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                if (parameters.get(i) instanceof BasicParameter) {
                    basicValues.put((BasicParameter)parameters.get(i), basicStart[i]);
                }
                ++i;
            }
            return InconsistencyStartingValueGenerator.generate((InconsistencyParameter)p, (InconsistencyParameterization)this.d_pmtz, startVal, basicValues);
        }
        throw new IllegalStateException("Unhandled parameter " + p + " of type " + p.getClass());
    }

    @Override
    protected void prepareModel() {
        if (this.d_pmtz == null) {
            this.d_pmtz = this.buildNetworkModel();
        }
        JDKRandomGenerator rng = new JDKRandomGenerator();
        double scale = this.getSettings().getVarianceScalingFactor();
        int i = 0;
        while (i < this.getNumberOfChains()) {
            this.d_startGen.add(AbstractDataStartingValueGenerator.create(this.d_network, rng, scale));
            ++i;
        }
        this.d_priorGen = new PriorGenerator(this.d_network);
        this.d_parameters = new ArrayList<NetworkParameter>(this.d_pmtz.getParameters());
        this.d_parameters.add(this.getRandomEffectsStandardDeviation());
        if (this.isInconsistency()) {
            this.d_parameters.add(this.d_inconsistencyStdDev);
        }
    }

    @Override
    protected List<Parameter> getParameters() {
        return this.d_parameters;
    }

    protected abstract Parameterization buildNetworkModel();

    protected Map<NetworkParameter, Derivation> getDerivedParameters() {
        HashMap<NetworkParameter, Derivation> map = new HashMap<NetworkParameter, Derivation>();
        for (Treatment t1 : this.d_network.getTreatments()) {
            for (Treatment t2 : this.d_network.getTreatments()) {
                BasicParameter p = new BasicParameter(t1, t2);
                if (t1.equals(t2) || this.d_pmtz.getParameters().contains(p)) continue;
                map.put(p, new Derivation(this.d_pmtz.parameterize(t1, t2)));
            }
        }
        return map;
    }

    @Override
    protected void createChain(int chain) {
        StartingValueGenerator startVal = this.d_startGen.get(chain);
        HashMap<Study, MCMCParameter> mu = new HashMap<Study, MCMCParameter>();
        for (Study s : this.d_network.getStudies()) {
            mu.put(s, new MCMCParameter(new double[]{startVal.getTreatmentEffect(s, this.d_pmtz.getStudyBaseline(s))}, new double[]{0.1}, null));
        }
        HashMap<Study, MCMCParameter> delta = new HashMap<Study, MCMCParameter>();
        for (Study s : this.d_network.getStudies()) {
            double[] start = new double[this.reDim(s)];
            double[] step = new double[this.reDim(s)];
            Arrays.fill(step, 0.1);
            int i = 0;
            for (List<Pair<Treatment>> list : this.d_pmtz.parameterizeStudy(s)) {
                for (Pair<Treatment> pair : list) {
                    start[i] = startVal.getRelativeEffect(s, this.getRelativeEffect(pair.getFirst(), pair.getSecond()));
                    ++i;
                }
            }
            delta.put(s, new MCMCParameter(start, step, null));
        }
        List<NetworkParameter> parameters = this.d_pmtz.getParameters();
        double[] basicStart = new double[parameters.size()];
        double[] basicStep = new double[parameters.size()];
        Arrays.fill(basicStep, 0.1);
        int i = 0;
        while (i < parameters.size()) {
            basicStart[i] = this.getStartingValue(startVal, parameters.get(i), basicStart);
            ++i;
        }
        MCMCParameter basic = new MCMCParameter(basicStart, basicStep, null);
        MCMCParameter sigma = new MCMCParameter(new double[]{this.getStartingSigma(startVal)}, new double[]{0.1}, null);
        MCMCParameter sigmaw = this.isInconsistency() ? new MCMCParameter(new double[]{this.getStartingSigma(startVal)}, new double[]{0.1}, null) : null;
        ArrayList<MCMCParameter> params = new ArrayList<MCMCParameter>();
        params.addAll(mu.values());
        params.addAll(delta.values());
        params.add(basic);
        params.add(sigma);
        if (this.isInconsistency()) {
            params.add(sigmaw);
        }
        switch (this.d_network.getType()) {
            case CONTINUOUS: {
                this.continuousDataBond(mu, delta);
                break;
            }
            case RATE: {
                this.dichotomousDataBond(mu, delta);
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to handle " + (Object)((Object)this.d_network.getType()) + " data");
            }
        }
        for (Study study : this.d_network.getStudies()) {
            this.relativeEffectBond(study, (MCMCParameter)delta.get(study), basic, sigma);
        }
        for (Study study : this.d_network.getStudies()) {
            new BasicMCMCBond(new MCMCParameter[]{(MCMCParameter)mu.get(study)}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(0.0, 1), new ConstantArgument(this.d_priorGen.getVagueNormalSigma(), 1)}, new Gaussian());
        }
        int nBasic = this.getNumberOfBasicParameters();
        int[] basicRange = new int[nBasic];
        int i2 = 0;
        while (i2 < nBasic) {
            basicRange[i2] = i2;
            ++i2;
        }
        new BasicMCMCBond(new MCMCParameter[]{basic}, new ArgumentMaker[]{new GroupArgument(0, basicRange), new ConstantArgument(0.0, nBasic), new ConstantArgument(this.d_priorGen.getVagueNormalSigma(), nBasic)}, new Gaussian());
        new BasicMCMCBond(new MCMCParameter[]{sigma}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(1.0E-5), new ConstantArgument(this.d_priorGen.getRandomEffectsSigma())}, new Uniform());
        if (this.isInconsistency()) {
            int nIncons = parameters.size() - nBasic;
            int[] inconsRange = new int[nIncons];
            int i3 = 0;
            while (i3 < nIncons) {
                inconsRange[i3] = nBasic + i3;
                ++i3;
            }
            new BasicMCMCBond(new MCMCParameter[]{basic, sigmaw}, new ArgumentMaker[]{new GroupArgument(0, inconsRange), new ConstantArgument(0.0, nIncons), new GroupArgument(1, new int[nIncons])}, new Gaussian());
            new BasicMCMCBond(new MCMCParameter[]{sigmaw}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(1.0E-5), new ConstantArgument(this.d_priorGen.getInconsistencySigma())}, new Uniform());
        }
        this.addTuners(params);
        ArrayList<ParameterWriter> writers = new ArrayList<ParameterWriter>(params.size());
        int i4 = 0;
        while (i4 < parameters.size()) {
            writers.add(this.d_results.getParameterWriter(parameters.get(i4), chain, basic, i4));
            ++i4;
        }
        writers.add(this.d_results.getParameterWriter(this.getRandomEffectsStandardDeviation(), chain, sigma, 0));
        if (this.isInconsistency()) {
            writers.add(this.d_results.getParameterWriter(this.d_inconsistencyStdDev, chain, sigmaw, 0));
        }
        this.addWriters(writers);
    }

    protected int getNumberOfBasicParameters() {
        List<NetworkParameter> parameters = this.d_pmtz.getParameters();
        int nBasic = 0;
        while (nBasic < parameters.size() && !(parameters.get(nBasic) instanceof InconsistencyParameter)) {
            ++nBasic;
        }
        return nBasic;
    }

    private void dichotomousDataBond(Map<Study, MCMCParameter> mu, Map<Study, MCMCParameter> delta) {
        for (Study study : this.d_network.getStudies()) {
            new BasicMCMCBond(new MCMCParameter[]{mu.get(study), delta.get(study)}, new ArgumentMaker[]{new ConstantArgument(this.successArray(study)), new ConstantArgument(this.sampleSizeArray(study)), new SuccessProbabilityArgumentMaker(NetworkModel.getTreatments(study), this.d_pmtz.parameterizeStudy(study), 0, 1)}, new Binomial());
        }
    }

    private void continuousDataBond(Map<Study, MCMCParameter> mu, Map<Study, MCMCParameter> delta) {
        for (Study study : this.d_network.getStudies()) {
            new BasicMCMCBond(new MCMCParameter[]{mu.get(study), delta.get(study)}, new ArgumentMaker[]{new ConstantArgument(this.obsMeanArray(study)), new ThetaArgumentMaker(NetworkModel.getTreatments(study), this.d_pmtz.parameterizeStudy(study), 0, 1), new ConstantArgument(this.obsErrorArray(study))}, new Gaussian());
        }
    }

    private double[] successArray(Study study) {
        List<Treatment> treatments = NetworkModel.getTreatments(study);
        double[] arr = new double[treatments.size()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = NetworkModel.findMeasurement(study, treatments.get(i)).getResponders().intValue();
            ++i;
        }
        return arr;
    }

    private double[] sampleSizeArray(Study study) {
        List<Treatment> treatments = NetworkModel.getTreatments(study);
        double[] arr = new double[treatments.size()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = NetworkModel.findMeasurement(study, treatments.get(i)).getSampleSize().intValue();
            ++i;
        }
        return arr;
    }

    private double[] obsMeanArray(Study study) {
        List<Treatment> treatments = NetworkModel.getTreatments(study);
        double[] arr = new double[treatments.size()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = NetworkModel.findMeasurement(study, treatments.get(i)).getMean();
            ++i;
        }
        return arr;
    }

    private double[] obsErrorArray(Study study) {
        List<Treatment> treatments = NetworkModel.getTreatments(study);
        double[] arr = new double[treatments.size()];
        int i = 0;
        while (i < arr.length) {
            Measurement m = NetworkModel.findMeasurement(study, treatments.get(i));
            arr[i] = m.getStdDev() / Math.sqrt(m.getSampleSize().intValue());
            ++i;
        }
        return arr;
    }

    private void relativeEffectBond(Study study, MCMCParameter delta, MCMCParameter basic, MCMCParameter sigma) {
        ArgumentMaker[] arguments = new ArgumentMaker[2 + this.reDim(study)];
        arguments[0] = new IdentityArgument(0);
        arguments[1] = new RelativeEffectArgumentMaker(this.d_pmtz, study, 1, -1);
        if (this.reDim(study) == 1) {
            arguments[2] = new IdentityArgument(2);
            new BasicMCMCBond(new MCMCParameter[]{delta, basic, sigma}, arguments, new Gaussian());
        } else {
            List<ArgumentMaker> rows = SigmaRowArgumentMaker.createMatrixArgumentMaker(this.d_pmtz.parameterizeStudy(study), 2);
            int i = 0;
            while (i < rows.size()) {
                arguments[2 + i] = rows.get(i);
                ++i;
            }
            new BasicMCMCBond(new MCMCParameter[]{delta, basic, sigma}, arguments, new MultivariateGaussian());
        }
    }

    private int reDim(Study s) {
        return s.getTreatments().size() - 1;
    }
}

