% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data_processing.R
\name{extractBarcodes}
\alias{extractBarcodes}
\title{Barcode extraction}
\usage{
extractBarcodes(dat, label, results_dir = "./", mismatch = 0,
  indels = FALSE, bc_backbone, full_output = FALSE, cpus = 1)
}
\arguments{
\item{dat}{a ShortReadQ object.}

\item{label}{a character string.}

\item{results_dir}{a character string which contains the path to the results directory.}

\item{mismatch}{an positive integer value, default is 0, if greater values are provided they indicate the number of allowed mismatches when identifing the barcode constructe.}

\item{indels}{under construction.}

\item{bc_backbone}{a character string or character vector describing the barcode design, variable positions have to be marked with the letter 'N'.}

\item{full_output}{a logical value. If TRUE additional output files will be generated in order to identify errors.}

\item{cpus}{an integer value, indicating the number of available cpus.}
}
\value{
one or a list of frequency table(s) of barcode sequences.
}
\description{
Extracts barcodes according to the given barcode design from a fastq file.
}
\examples{

\dontrun{

bc_backbone <- "ACTNNCGANNCTTNNCGANNCTTNNGGANNCTANNACTNNCGANNCTTNNCGANNCTTNNGGANNCTANNACTNNCGANN"
source_dir <- system.file("extdata", package = "genBaRcode")
dat <- ShortRead::readFastq(dirPath = source_dir, pattern = "test_data.fastq")

extractBarcodes(dat, label = "test", results_dir = getwd(), mismatch = 0,
indels = FALSE, bc_backbone)

}
}
