% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data_processing.R
\name{extractBarcodes_multiple}
\alias{extractBarcodes_multiple}
\title{Barcode extraction for multiple backbones}
\usage{
extractBarcodes_multiple(dat, label, results_dir, mismatch = 0,
  indels = FALSE, bc_backbone, full_output)
}
\arguments{
\item{dat}{a ShortReadQ object.}

\item{label}{a character string.}

\item{results_dir}{a character string which contains the path to the results directory.}

\item{mismatch}{an positive integer value, default is 0, if greater values are provided they indicate the number of allowed mismatches when identifing the barcode constructe.}

\item{indels}{under construction.}

\item{bc_backbone}{a character string or character vector describing the barcode design, variable positions have to be marked with the letter 'N'.}

\item{full_output}{a logical value. If TRUE additional output files will be generated in order to identify errors.}
}
\value{
a list of frequency table(s) of barcode sequences.
}
\description{
Extracts barcodes according to the given barcode design from a fastq file.
}
