% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genBartFile.R
\name{genFile}
\alias{genFile}
\alias{updateFile}
\title{Generate and Update BART Result files}
\usage{
genFile(meta, model.results = NULL, module.scores = NULL,
  dendrograms = NULL, qusage.results = NULL, roast.results = NULL,
  corr.results = NULL, project.name = "BART Project", folder.path = NULL)

updateFile(load.path = NULL, output.path = NULL, meta = NULL,
  model.results = NULL, module.scores = NULL, dendrograms = NULL,
  qusage.results = NULL, roast.results = NULL, corr.results = NULL,
  project.name = NULL)
}
\arguments{
\item{meta}{A list of a single or multiple objects returned by 
\code{metaData}. Default is NULL.}

\item{model.results}{A list of a single or multiple objects returned by 
\code{genModelResults}. Default is NULL.}

\item{module.scores}{Object returned by \code{genModScores}. Default is 
NULL.}

\item{dendrograms}{Object returned by \code{clusterData}. Default is NULL.}

\item{qusage.results}{Object returned by \code{runQgen}. Default is NULL.}

\item{roast.results}{Object returned by \code{rBart}. Default is NULL.}

\item{corr.results}{A list of a single or multiple objects returned by 
\code{crossCorr}. Default is NULL.}

\item{project.name}{String giving the name project name. Default is 
"BART Project".}

\item{folder.path}{Path to create folder that BART file will be saved to. If 
NULL (default), BART folder will be created in the current working 
directory.}

\item{load.path}{Folder path of BART file that needs to be updated.}

\item{output.path}{Folder path to save updated BART file. If NULL (default),
updated BART file will override the old one.}
}
\description{
Generate/Update BART file that can be directly uploaded into the BART app
}
\details{
\code{genFile} generates a formatted R data file (bartResults.rda) 
  that can be uploaded into the BART web application. The file is created 
  based on result objects returned by the various functions in 
  \code{genBart}. Since BART can store and display results across multiple 
  platforms at one time (e.g. RNA-seq, flow cytometry, metabolomics), some of 
  the parameters (i.e. meta, model.results, corr.results) require the input 
  objects to be wrapped in a list. The function saves the file in a folder 
  whose name is given by \code{project.name}. The folder is created in the 
  current working directory.

\code{updateFile} takes an existing BART file and allows the user to
  easily add and/or revise components. The user can override the old BART
  file by leaving \code{output.path} as NULL or give a new path in which to
  save the updated file.
}
\examples{
# Example data
data(tb.expr)
data(tb.design)

# Use first 100 probes to demonstrate
dat <- tb.expr[1:100,]

# Create desInfo object
meta.data <- metaData(y = dat, design = tb.design, data.type = "microarray", 
                    columnname = "columnname", long = TRUE, subject.id = "monkey_id",
                    baseline.var = "timepoint", baseline.val = 0, time.var = "timepoint", 
                    sample.id = "sample_id")
                    
# create BART file (minimal example)
genFile(meta = list(meta.data), folder.path = tempdir())                     

# generate module scores, normalize and cluster genes
mods <- genModScores(meta.data, modules)
data.norm <- normalizeData(meta = meta.data)
dendros <- clusterData(norm.data = data.norm)

# Update BART file with module scores and clustered genes
path <- paste0(tempdir(), "/", "BART Project")
updateFile(load.path = path, module.scores = mods, dendrograms = dendros)
}
