#' @title Gene Haplotype Statistics, Pheno Associations, and Visualization
#' @description
#' This packages provides a suite for gene(s) haplotype analysis,
#' phenotypes association and visualization of geography distribution.
#' @details
#' The haplotype analysis requires sequences such as fasta which could be
#' import by \link[geneHapR:import_vcf]{import_vcf}
#'
#' **A complete list of functions** can be displayed with:
#' `library(help = 'geneHapR')`.
#'
#' **Vignettes** (documentation) can be listed with:
#' `browseVignettes('geneHapR')`.
#'
#' Several small example **datasets** are included in 'geneHapR'.
#' **vcf** and **seqs** provide a data set for test of `seq2hap()` and
#' `seqs2hap()`.
#' **gff** provide a data set for visualization mutations on gene model.
#' **pheno** provide a data set for phenotype comparison between haplotypes.
#' **AccINFO** provide a data provide accessions information for
#' pie plot in hapNet visualization, and information for geography distrbution.
#' @seealso
#' More documentation for 'geneHapR' could be found at repos under
#' \href{https://gitee.com/zhangrenl}{gitee}
#' @keywords internal
"_PACKAGE"
