% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_network.R
\name{network}
\alias{network}
\alias{get_hapNet}
\alias{getHapGroup}
\title{Generate Haplotype Net Relationshop with Haplotype Result}
\usage{
get_hapNet(hapSummary,
           AccINFO = AccINFO,
           groupName = groupName,
           na.label = "Unknown")

getHapGroup(
  hapSummary,
  AccINFO = AccINFO,
  groupName = groupName,
  na.label = na.label
)
}
\arguments{
\item{hapSummary}{object of \code{hapSummary} class, generated by \code{hap_summary()}}

\item{AccINFO}{data.frame, specified groups of each accession.
Used for pie plot. If missing, pie will not draw in plotHapNet.
Or you can supplied a hap_group mattrix with \code{plot(hapNet, pie = hap_group)}.}

\item{groupName}{the group name used for pie plot,
should be in \code{AccINFO} column names, default as the first column name}

\item{na.label}{the label of \code{NA}s}
}
\value{
hapNet class
}
\description{
computes a haplotype network with haplotype summary result
}
\examples{

\donttest{
data("geneHapR_test")
hapSummary <- hap_summary(hapResult)

# calculate haploNet
hapNet <- get_hapNet(hapSummary,
                     AccINFO = AccINFO, # accession types
                     groupName = colnames(AccINFO)[2])

# plot haploNet
plot(hapNet)

# plot haploNet
plotHapNet(hapNet,
           size = "freq",   # circle size
           scale = "log10", # scale circle with 'log10(size + 1)'
           cex = 1, # size of hap symbol
           col.link = 2, # link colors
           link.width = 2, # link widths
           show.mutation = 2, # mutation types one of c(0,1,2,3)
           legend = FALSE) # legend position
}
}
\references{
Mark P.J. van der Loo (2014)
\doi{10.32614/RJ-2014-011};

E. Paradis (2010)
\doi{10.1093/bioinformatics/btp696}
}
\seealso{
\code{\link[geneHapR:plotHapNet]{plotHapNet()}} and
\code{\link[geneHapR:hap_summary]{hap_summary()}}.
}
