% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnrich.R
\name{plotEnrich}
\alias{plotEnrich}
\title{Plot for gene enrichment analysis of ORA method}
\usage{
plotEnrich(
  enrich_df,
  fold_change = NULL,
  plot_type = c("bar", "wego", "dot", "bubble", "lollipop", "geneheat", "genechord",
    "network", "gomap", "goheat", "gotangram", "wordcloud", "upset"),
  term_metric = c("FoldEnrich", "GeneRatio", "Count", "RichFactor"),
  stats_metric = c("p.adjust", "pvalue", "qvalue"),
  sim_method = c("Resnik", "Lin", "Rel", "Jiang", "Wang", "JC"),
  up_color = "#E31A1C",
  down_color = "#1F78B4",
  show_gene = "all",
  xlim_left = 0,
  xlim_right = NA,
  wrap_length = NULL,
  org = NULL,
  ont = NULL,
  scale_ratio,
  layout,
  n_term,
  ...
)
}
\arguments{
\item{enrich_df}{Enrichment analysis `data.frame` result.}

\item{fold_change}{Fold change or logFC values with gene IDs as names. Used in "heat" and "chord"
plot.}

\item{plot_type}{Choose from "bar", "wego","bubble","dot", "lollipop","geneheat", "genechord",
"network","gomap","goheat","gotangram","wordcloud","upset".}

\item{term_metric}{Pathway term metric from one of 'GeneRatio','Count','FoldEnrich' and
'RichFactor'.}

\item{stats_metric}{Statistic metric from one of "pvalue", "p.adjust", "qvalue".}

\item{sim_method}{Method of calculating the similarity between nodes, one of one of "Resnik",
"Lin", "Rel", "Jiang" , "Wang" or "JC" (Jaccard’s similarity index). Only "JC" supports KEGG data.
Used in "map","goheat","gotangram","wordcloud".}

\item{up_color}{Color of higher statistical power (e.g. Pvalue 0.01) or higher logFC, default is "red".}

\item{down_color}{Color of lower statistical power (e.g. Pvalue 1) or lower logFC, default is
"blue".}

\item{show_gene}{Select genes to show. Default is "all". Used in "heat" and "chord" plot.}

\item{xlim_left}{X-axis left limit, default is 0.}

\item{xlim_right}{X-axis right limit, default is NA.}

\item{wrap_length}{Numeric, wrap text if longer than this length. Default is NULL.}

\item{org}{Organism name from `biocOrg_name`.}

\item{ont}{One of "BP", "MF", and "CC".}

\item{scale_ratio}{Numeric, scale of node and line size.}

\item{layout}{Grapgh layout in "map" plot, e,g, "circle", "dh", "drl", "fr","graphopt", "grid",
"lgl", "kk", "mds", "nicely" (default),"randomly", "star".}

\item{n_term}{Number of terms (used in WEGO plot)}

\item{...}{other arguments from `plot_theme` function}
}
\value{
A ggplot object
}
\description{
Over-representation analysis (ORA) is a simple method for objectively deciding whether a set of variables of
known or suspected biological relevance, such as a gene set or pathway, is more prevalent in a set of variables
of interest than we expect by chance.
}
\examples{
\donttest{
## example data
library(ggplot2)
library(igraph)
library(ggraph)
data(geneList, package = "genekitr")
id <- names(geneList)[abs(geneList) > 1.5]
logfc <- geneList[id]

gs <- geneset::getGO(org = "human",ont = "bp")
ego <- genORA(id, geneset = gs)
ego <- ego[1:10, ]

## example plots
plotEnrich(ego, plot_type = "dot")

plotEnrich(ego, plot_type = "bubble", scale_ratio = 0.4)

plotEnrich(ego, plot_type = "bar")

plotEnrich(ego,
  plot_type = "lollipop",
  down_color = "#325CAC", up_color = "#E69056",
  wrap_length = 25, scale_ratio = 0.4
)

plotEnrich(ego, plot_type = "geneheat")

show_gene <- c("BRCA2", "CDK1", "JUN", "MCM8", "TIPIN")
plotEnrich(ego, plot_type = "geneheat", show_gene = show_gene)
plotEnrich(ego, fold_change = logfc, plot_type = "geneheat", show_gene = show_gene)

plotEnrich(ego, fold_change = logfc, plot_type = "genechord", show_gene = show_gene)

plotEnrich(ego, plot_type = "network", scale_ratio = 0.5)

plotEnrich(ego, plot_type = "gomap", wrap_length = 25)

plotEnrich(ego, plot_type = "goheat", sim_method = "Rel")

plotEnrich(ego, plot_type = "gotangram", sim_method = "Rel")

plotEnrich(ego, plot_type = "wordcloud")

plotEnrich(ego, plot_type = "upset",main_text_size = 15,legend_text_size = 8)
}

}
