% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochdom2.R
\name{stochdom2}
\alias{stochdom2}
\title{Compute vectors measuring stochastic dominance of four orders.}
\usage{
stochdom2(dj, wpa, wpb)
}
\arguments{
\item{dj}{these are (unequal) distances of consecutive intervals}

\item{wpa}{weighted probabilities of first set of probabilities}

\item{wpb}{weighted probabilities of second set of probabilities}
}
\value{
\item{sd1b}{vector measuring stochastic dominance of order 1, SD1} 
\item{sd2b}{vector measuring stochastic dominance of order 2, SD2} 
\item{sd3b}{vector measuring stochastic dominance of order 3, SD3} 
\item{sd4b}{vector measuring stochastic dominance of order 4, SD4}
}
\description{
Stochastic dominance is a sophisticated comparison of two distributions of
stock market returns.  The dominating distribution is superior in terms of
mean, variance, skewness and kurtosis respectively, representing dominance
orders 1 to 4, without directly computing four moments.  Vinod(2008) sec. 4.3
explains the details.  This function directly uses the output of `wtdpapb'.
}
\examples{

 \dontrun{
 set.seed(234);x=sample(1:30);y=sample(5:34)
 w1=wtdpapb(x,y)
 stochdom2(w1$dj, w1$wpa, w1$wpb) }

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D.", "Hands-On Intermediate Econometrics 
 Using R"  (2008) World Scientific Publishers: Hackensack, NJ.
 \url{http://www.worldscibooks.com/economics/6895.html}

Vinod, H. D. "Ranking Mutual Funds Using 
Unconventional Utility Theory and Stochastic Dominance,"
Journal of Empirical Finance Vol. 11(3) 2004, pp. 353-377.
}
\seealso{
See Also \code{\link{wtdpapb}}
}
\keyword{kurtosis}
\keyword{mean}
\keyword{skewness}
\keyword{variance}

