% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtdpapb.R
\name{wtdpapb}
\alias{wtdpapb}
\title{Creates input for the function stochdom2 for stochastic dominance.}
\usage{
wtdpapb(xa, xb)
}
\arguments{
\item{xa}{{vector of (excess) returns for the first investment option A or
values of any random variable being compared to another.}}

\item{xb}{vector of returns for the second option B}
}
\value{
\item{wpa}{weighted vector of probabilities for option A} 
\item{wpb}{weighted vector of probabilities for option B} 
\item{dj}{vector of distances when both values atre forced on the same support}
}
\description{
Stochastic dominance is a sophisticated comparison of two distributions of
stock market returns.  The dominating distribution is superior in terms of
mean, variance, skewness and kurtosis respectively, representing dominance
orders 1 to 4, without directly computing four moments.  Vinod(2008) sec. 4.3
explains the details.  The `wtdpapb' function creates the input
for stochdom2 which in turn computes the stochsastic dominance.
See Vinod (2004) for details about quantitative stochastic dominance.
}
\note{
Internal function needed for stochastic dominance

In Vinod (2008) where the purpose of \code{wtdpapb} is to map from standard
`expected utility theory' weights to more sophisticated `non-expected utility
theory' weights using Prelec's (1998, Econometrica, p. 497) method.  These
 weights are not needed here. Hence we provide the function \code{prelec2}
 which does not use Prelec weights at all, thereby simplifying and speeding up
 the R code provided in Vinod (2008).
}
\examples{

 \dontrun{
 set.seed(234);x=sample(1:30);y=sample(5:34)
 wtdpapb(x,y)}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D.", "Hands-On Intermediate Econometrics 
Using R"  (2008) World Scientific Publishers: Hackensack, NJ.
\url{http://www.worldscibooks.com/economics/6895.html}

Vinod, H. D. "Ranking Mutual Funds Using 
Unconventional Utility Theory and Stochastic Dominance,"
Journal of Empirical Finance Vol. 11(3) 2004, pp. 353-377.
}
\keyword{dominance}
\keyword{stochastic}

