% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigfp.R
\name{bigfp}
\alias{bigfp}
\title{Compute the numerical integration by the trapezoidal rule.}
\usage{
bigfp(d, p)
}
\arguments{
\item{d}{{A vector of distances from the smallest value from both data vectors}}

\item{p}{{Vector of probabilities of the type 1/2T, 2/2T, 3/2T, etc. to 1.}}
}
\value{
Returns a result after pre-multiplication by \eqn{I_F,  I_f}
matrices, without actually creating the large sparse matrices. This is an internal function.
}
\description{
See page 220 of Vinod's ``Hands-on Interemediate Econometrics Using R,'' cited below
for the trapezoidal integration formula
needed for stochastic dominance.  The book explains pre-multiplication by two
large sparse matrices denoted by \eqn{I_F,  I_f}.  Here we accomplish the 
same computation without actually creating the large sparse matrices. For example, the
\eqn{I_f} is replaced by \code{cumsum} in this code (unlike the R code in
my textbook).
}
\note{
This is an internal function, called by the function \code{stochdom2}, for
 comparison of two portfolios in terms of stochastic dominance (SD) of orders
 1 to 4.
Typical usage is:
\code{sd1b=bigfp(d=dj, p=rhs)
sd2b=bigfp(d=dj, p=sd1b)
sd3b=bigfp(d=dj, p=sd2b)
sd4b=bigfp(d=dj, p=sd3b)}.
This produces numerical evaluation vectors for the four orders, SD1  to SD4.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D.', 'Hands-On Intermediate Econometrics
Using R'  (2008) World Scientific Publishers: Hackensack, NJ.
\url{http://www.worldscibooks.com/economics/6895.html}
}
\keyword{SD1}
\keyword{SD2}
\keyword{SD3}
\keyword{SD4}

