% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcor_ijk.R
\name{parcor_ijk}
\alias{parcor_ijk}
\title{Generalized partial correlation coefficients between Xi and Xj after removing the
effect of xk.}
\usage{
parcor_ijk(xi, xj, xk)
}
\arguments{
\item{xi}{{Input vector of data for variable xi}}

\item{xj}{{Input vector of data for variable xj}}

\item{xk}{{Input data for variables in xk, usually control variables}}
}
\value{
\item{ouij}{Generalized partial correlation Xi with Xj (=cause) after removing xk}
\item{ouji}{Generalized partial correlation Xj with Xi (=cause) after removing xk}
}
\description{
This function uses data on two column vectors, xi, xj and 
xk which can be a vector or a matrix usually of the remaining control
variables.
}
\note{
This function calls \code{\link{kern}},
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
parcor_ijk(gm1, 2,3)
}#' 
}
