% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_regimen_sunburst.R
\name{drug_regimen_sunburst}
\alias{drug_regimen_sunburst}
\title{Visualize drug regimen sequences in a sunburst plot}
\usage{
drug_regimen_sunburst(data_synapse, data_cohort, max_n_regimens = NULL)
}
\arguments{
\item{data_synapse}{The item from the nested list returned from
`pull_data_synapse()`}

\item{data_cohort}{The list returned from the `create_analytic_cohort()`
function call}

\item{max_n_regimens}{The maximum number of regimens displayed in the
sunburst plot}
}
\value{
Returns data frame `treatment_history` and interactive
plot `sunburst_plot`
}
\description{
This function allows the user to visualize the complete treatment
course for selected cancer diagnoses.
}
\details{
See the \href{https://genie-bpc.github.io/genieBPC/articles/drug_regimen_sunburst_vignette.html}{drug_regimen_sunburst vignette}
for additional details and examples.
}
\examples{
# Example 1 ----------------------------------
# Example using package test data
# get clinico-genomic files for a specific cohort
nsclc_sub <- create_analytic_cohort(
  data_synapse = genieBPC::nsclc_test_data,
  stage_dx = c("Stage III", "Stage IV")
)

# create sunburst plot
ex1 <- drug_regimen_sunburst(
  data_synapse = nsclc_test_data,
  data_cohort = nsclc_sub,
  max_n_regimens = 3
)

\dontshow{if (genieBPC::.is_connected_to_genie()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 2 ----------------------------------
# using pull_data_synapse
nsclc_2_0 <- pull_data_synapse("NSCLC", version = "v2.0-public")

nsclc_stg_iv <- create_analytic_cohort(
  data_synapse = nsclc_2_0$NSCLC_v2.0,
  stage = "Stage IV"
)

ex2 <- drug_regimen_sunburst(
  data_synapse = nsclc_2_0$NSCLC_v2.0,
  data_cohort = nsclc_stg_iv,
  max_n_regimens = 3
)
\dontshow{\}) # examplesIf}
}
