% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_data_synapse.R
\name{.pull_data_by_cohort}
\alias{.pull_data_by_cohort}
\title{Function to retrieve data by synapse ID}
\usage{
.pull_data_by_cohort(version_num_df, token, download_location)
}
\arguments{
\item{version_num_df}{a dataframe of 'Synapse' IDs}

\item{token}{a 'Synapse' token}

\item{download_location}{if `NULL` (default), data will be returned as a list
of dataframes with requested data as list items. Otherwise, specify a
folder path to have data automatically downloaded there.}
}
\value{
downloaded 'Synapse' data as a list if `download_location`= `NULL, or
  to a local path
}
\description{
Function to retrieve data by synapse ID
}
\examples{
\dontshow{if (genieBPC::.is_connected_to_genie()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

temp_directory <- tempdir()

syn_df <- data.frame(
  cohort = c("NSCLC", "NSCLC"),
  version = c("v2.2-consortium", "v2.0-public"),
  version_num = c("NSCLC_v2.2", "NSCLC_v2.0"),
  download_folder = c(temp_directory, temp_directory),
  df = c("pt_char", "ca_dx_index"),
  synapse_id = c("syn53470868", "syn30350575")
)

.pull_data_by_cohort(
  version_num_df = syn_df,
  token = .get_synapse_token(), download_location = NULL
)

#
\dontshow{\}) # examplesIf}
}
\keyword{internal}
