% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_matrix.R
\name{read_matrix}
\alias{read_matrix}
\title{Read a numerical matrix file into an R matrix}
\usage{
read_matrix(file, ext = "txt", verbose = TRUE)
}
\arguments{
\item{file}{Input file (whatever is accepted by \code{\link[readr:read_table]{readr::read_table2()}}).
If file as given does not exist and is missing the expected extension (see \code{ext} below), the function adds the extension and uses that path if that file exists.
Additionally, the .gz extension is added automatically if the file (after the extension is added as needed) is still not found and did not already contain the .gz extension and adding it points to an existing file.}

\item{ext}{The desired file extension.
Ignored if \code{file} points to an existing file.}

\item{verbose}{If \code{TRUE} (default) function reports the path of the file being loaded (after autocompleting the extensions).}
}
\value{
A numeric matrix without row or column names.
}
\description{
Reads a matrix file under strict assumptions that it is entirely numeric and there are no row or column names present in this file.
It uses \code{\link[readr:read_table]{readr::read_table2()}} to do it efficiently.
Intended for outputs such as those of admixture inference approaches.
}
\examples{
# to read "data.txt", run like this:
# mat <- read_matrix("data")
# this also works
# mat <- read_matrix("data.txt")

# The following example is more awkward
# because package sample data has to be specified in this weird way:

# read an existing matrix *.txt file
file <- system.file("extdata", 'sample-Q3.txt', package = "genio", mustWork = TRUE)
mat <- read_matrix(file)
mat

# can specify without extension
file <- sub('\\\\.txt$', '', file) # remove extension from this path on purpose
file # verify .txt is missing
mat <- read_matrix(file) # load it anyway!
mat

}
\seealso{
\code{\link[=write_matrix]{write_matrix()}}, the inverse function.
}
