% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_eigenvec.R
\name{read_eigenvec}
\alias{read_eigenvec}
\title{Read Plink eigenvec file}
\usage{
read_eigenvec(file, ext = "eigenvec", comment = "#", verbose = TRUE)
}
\arguments{
\item{file}{The input file path, potentially excluding extension.}

\item{ext}{File extension (default "eigenvec") can be changed if desired.
Set to \code{NA} to force \code{file} to exist as-is.}

\item{comment}{A string used to identify comments.
Any text after the comment characters will be silently ignored.
Passed to \code{\link[readr:read_table]{readr::read_table()}}.
'#' (default) works for Plink 2 eigenvec files, which have a header lines that starts with this character (the header is therefore ignored).}

\item{verbose}{If \code{TRUE} (default) function reports the path of the file being written (after autocompleting the extension).}
}
\value{
A list with two elements:
\itemize{
\item \code{eigenvec}: A numeric R matrix containing the parsed eigenvectors
\item \code{fam}: A tibble with two columns, \code{fam} and \code{id}, which are the first two columns of the parsed file.
}
}
\description{
This function reads a Plink eigenvec file, parsing columns strictly.
First two must be 'fam' and 'id', which are strings, and all remaining columns (eigenvectors) must be numeric.
}
\examples{
# to read "data.eigenvec", run like this:
# data <- read_eigenvec("data")
# this also works
# data <- read_eigenvec("data.eigenvec")
#
# either way you get a list with these two items:
# numeric eigenvector matrix
# data$eigenvec
# fam/id tibble
# data$fam

# The following example is more awkward
# because package sample data has to be specified in this weird way:

# read an existing *.eigenvec file created by GCTA
file <- system.file("extdata", 'sample-gcta.eigenvec', package = "genio", mustWork = TRUE)
data <- read_eigenvec(file)
# numeric eigenvector matrix
data$eigenvec
# fam/id tibble
data$fam

# can specify without extension
file <- sub('\\\\.eigenvec$', '', file) # remove extension from this path on purpose
file # verify .eigenvec is missing
data <- read_eigenvec(file) # load it anyway!
data$eigenvec

# read an existing *.eigenvec file created by Plink 2
file <- system.file("extdata", 'sample-plink2.eigenvec', package = "genio", mustWork = TRUE)
data <- read_eigenvec(file)
# numeric eigenvector matrix
data$eigenvec
# fam/id tibble
data$fam

}
\seealso{
\code{\link[=write_eigenvec]{write_eigenvec()}} for writing an eigenvec file.

Plink 1 eigenvec format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#eigenvec}

Plink 2 eigenvec format reference:
\url{https://www.cog-genomics.org/plink/2.0/formats#eigenvec}

GCTA eigenvec format reference:
\url{https://cnsgenomics.com/software/gcta/#PCA}
}
