% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{read_one_term}
\alias{read_one_term}
\title{Parses the first term of a non-uniform expression.}
\usage{
read_one_term(s)
}
\arguments{
\item{s}{A string, the variable side of a non-uniform inequality expression (i.e. terms must be rewritten in e.g. \code{x1}, \code{x2} as opposed to \code{x}).}
}
\value{
A list containing the following elements:
   \item{idx}{An integer, the index of the first term (e.g. \code{3} for \code{1.3*x3^(-2/5))}).}
   \item{power_numer}{An integer, the power_numer of the first term.}
   \item{power_denom}{An integer, the power_denom of the first term.}
   \item{coef}{A number, the coefficient on the first term (e.g. \code{1.3} for \code{1.3*x3^(-2/5)}).}
   \item{s}{A string, the rest of the unparsed string.}
}
\description{
Parses the first term of a non-uniform expression.
}
\details{
Parses the first term in a non-uniform expression and returns the rest of the terms.
}
\examples{
read_one_term("0.5*x1+x2^2")
read_one_term("2e3x1^(2/3)-1.3x2^(-3)")
read_one_term("2exp(3x1)+2.3*x2^2")
read_one_term(paste(sapply(1:10, function(j){paste(j, "x", j, "^", (11-j), sep="")}), collapse="+"))
read_one_term("0.5*x1^(-2/3)-x3^3 + 2log(x2)- 1.3e4exp(-25*x6)+x8-.3x5^(-3/-4)")
read_one_term("-1e-4x1^(-2/3)-x2^(4/-6)+2e3x3^(-6/9) < 3.5e5")
}
