% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape.r
\name{shape}
\alias{shape}
\title{reshapes a data set from wide to long or from long to wide formats}
\usage{
shape(form, direction = "long")
}
\arguments{
\item{form}{if direction="long", then the argument should have the form:

id1+id2+..~newvar|stub

where there are variables in the data set named "stubXXXX" and "newvar" is the name of the new variable that will be added to the data set which will contain the various values of "stubXXXX" on exit.  The variable "stub" on exit will contain the value of "XXXX".  Variables (id1,id2,...) will also be included in the dataset on exit.  The command behaves like "reshape long stub, i(id1 id2 ...) j(newvar)" in Stata.

If direction="wide", then the argument should have the form,

id1+id2+...~values1+values2+...|byvar1+byvar2+...

The variables (id1,id2,...,byvar1,byvar2,...) should uniqely identify observations in the data.  On exit the dataset will contain (id1,id2,...) in addition to values1byvar1.byvar2, values2byvar1.byvar2, ... for each unique value of (byvar1,byvar2,...).  The command behaves like "reshape wide values1 values2 ..., i(id1 id2 ...) j(byvar1...)}

\item{direction}{either "long" or "wide" to indicate the direction to reorient the data set}
}
\value{
returns NULL, invisibly
}
\description{
reshapes a data set from wide to long or from long to wide formats
}
\examples{
library(plm)
data(Produc)
use(Produc, clear=TRUE)
listif()
shape(state~emp|year, direction="wide")
listif()
shape(state~year|emp, direction="long")
listif()
}
