% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skelpnts.R
\name{alik_optim}
\alias{alik_optim}
\title{Log-likelihood maximisation}
\usage{
alik_optim(paroptim, formula, family = "gaussian", data, weights, subset,
  atsample, corrfcn = "matern", np, betm0, betQ0, ssqdf, ssqsc,
  dispersion = 1, longlat = FALSE, control = list())
}
\arguments{
\item{paroptim}{A named list with the components "linkp", "phi",
"omg", "kappa". Each component must be numeric with length 1, 2,
or 3 with elements in increasing order. If the compontent's
length is 1, then the corresponding parameter is considered to
be fixed at that value. If 2, then the two numbers denote the
lower and upper bounds for the optimisation of that parameter
(infinities are allowed). If 3, these correspond to lower bound,
starting value, upper bound for the estimation of that
parameter.}

\item{formula}{A representation of the model in the form
\code{response ~ terms}.}

\item{family}{The distribution of the response.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples for Gaussian and gamma, number of trials for binomial,
time length for Poisson.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{corrfcn}{Spatial correlation function. See
\code{\link{geoBayes_correlation}} for details.}

\item{np}{The number of integration points for the spatial
variance parameter sigma^2. The total number of points will be
\code{2*np + 1}.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix. Can be a scalar, vector or matrix. The first two imply a
diagonal with those elements. Set this to 0 to indicate a flat
improper prior.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{dispersion}{The fixed dispersion parameter.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{control}{A list of control parameters for the optimisation.
See \code{\link[stats]{optim}}.}
}
\value{
The output from the function \code{\link[stats]{optim}}.
  The \code{"value"} element is the log-likelihood, not the
  negative log-likelihood.
}
\description{
Approximate log-likelihood maximisation
}
\details{
Uses the "L-BFGS-B" method of the function
\code{\link[stats]{optim}} to maximise the log-likelihood for the
parameters \code{linkp}, \code{phi}, \code{omg}, \code{kappa}.
}
