% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{mkpredgrid2d}
\alias{mkpredgrid2d}
\title{Make prediction grid}
\usage{
mkpredgrid2d(pnts.x, pnts.y, par.x, par.y, isby = FALSE, chull = FALSE,
  exf = 1)
}
\arguments{
\item{pnts.x}{x coordinate of the domain. Could also be a
two-column matrix containing the x and y coordinates}

\item{pnts.y}{y coordinate of the domain. Should be
omitted or set to \code{NULL} if the argument \code{pnts.x} is a
two-column matrix.}

\item{par.x}{A scalar parameter for the x component of the new
grid. This parameter corresponds to either the \code{by} or the
\code{length.out} arguments of the function
\code{\link[base]{seq}}. Could also be a vector of two elements
containing the parameter for x and y.}

\item{par.y}{As in \code{par.x} for the y component of the new
grid. Should be omitted or set to \code{NULL} if the argument
\code{par.x} is a two-dimensional vector.}

\item{isby}{If \code{TRUE}, the arguments \code{par.x} and
\code{par.y} correspond to the \code{by} argument of the function
\code{\link[base]{seq}}, otherwise they correspond to
\code{length.out}.}

\item{chull}{Whether to calculate the convex hull of the points.
Set this to \code{TRUE} if \code{pnts.x} and \code{pnts.y} denote
the sampled locations. If they correspond to the borders of the
domain, it is recommended to set this to \code{FALSE}.}

\item{exf}{An expansion factor of the convex hull of
\code{cbind(pnts.x, pnts.y)}. Must be positive. If larger or
smaller than 1, the convex hull is respectively expanded or
contracted.}
}
\value{
A list with components
\itemize{
\item \code{grid} A two-column matrix with the prediction grid.
\item \code{xycoord} A list with components "x" and "y"
containing the sequence of points used to create the grid.
\item \code{xygrid} A matrix with the full square grid derived
from \code{xycoord}.
\item \code{borders} The (expanded) borders of the domain.
\item \code{inxygrid} A logical vector indicating which rows of
  \code{xycoord} fall inside \code{borders}, and therefore
  correspond to the \code{grid}.
}
}
\description{
This function creates a grid for prediction.
}
\details{
If \code{chull} this function first calculates the convex hull of
the points. If \code{exf} is not 1 the borders are expanded. Then
the function calls \code{\link[sp]{point.in.polygon}} to select
points that fall inside the borders.
}
\examples{
\dontrun{
data(rhizoctonia)
predgrid <- mkpredgrid2d(rhizoctonia[c("Xcoord", "Ycoord")],
                         par.x = 100, chull = TRUE, exf = 1.2)
plot(predgrid$borders, type = "l")         # Domain for prediction
points(predgrid$grid, pch = 20, cex = .3)  # Prediction locations
points(rhizoctonia[c("Xcoord", "Ycoord")]) # Observed locations
}
}
\seealso{
\code{\link[geoR]{pred_grid}}
}
