% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skelpnts.R
\name{alik_inla}
\alias{alik_inla}
\title{Log-likelihood approximation}
\usage{
alik_inla(
  par_vals,
  formula,
  family = "gaussian",
  data,
  weights,
  subset,
  offset,
  atsample,
  corrfcn = "matern",
  np,
  betm0,
  betQ0,
  ssqdf,
  ssqsc,
  tsqdf,
  tsqsc,
  dispersion = 1,
  longlat = FALSE
)
}
\arguments{
\item{par_vals}{A data frame with the components "linkp", "phi",
"omg", "kappa". The approximation will be computed at each row
of the data frame.}

\item{formula}{A representation of the model in the form
\code{response ~ terms}.}

\item{family}{The distribution of the response. Can be one of the
options in \code{\link{.geoBayes_models}} or
\code{"transformed.gaussian"}.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples for Gaussian and gamma, number of trials for binomial,
time length for Poisson.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{offset}{See \code{\link[stats]{lm}}.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{corrfcn}{Spatial correlation function. Can be one of the
choices in \code{\link{.geoBayes_corrfcn}}.}

\item{np}{The number of integration points for the spatial
variance parameter sigma^2. The total number of points will be
\code{2*np + 1}.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix. Can be a scalar, vector or matrix. The first two imply a
diagonal with those elements. Set this to 0 to indicate a flat
improper prior.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{tsqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the measurement error parameter.}

\item{tsqsc}{Scale for the scaled inverse chi-square prior for the
measurement error parameter.}

\item{dispersion}{The fixed dispersion parameter.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}
}
\value{
A list with components
\itemize{
\item \code{par_vals} A data frame of the parameter values.
\item \code{aloglik} The approximate log-likelihood at thos
  parameter values.
}
}
\description{
Log-likelihood approximation.
}
\details{
Computes and approximation to the log-likelihood for the given
parameters using integrated nested Laplace approximations.
}
\references{
Evangelou, E., & Roy, V. (2019). Estimation and prediction for
  spatial generalized linear mixed models with parametric links
  via reparameterized importance sampling. Spatial Statistics, 29,
  289-315.
}
