% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{spc.plot.time.plotly}
\alias{spc.plot.time.plotly}
\alias{spc.plot.time.plotly,Spectra-method}
\title{Plot a Spectra object data with respect to time}
\usage{
spc.plot.time.plotly(sp, column, plot.max = 10, showlegend = FALSE,
  hoverinfo = "name", title = sp@LongName)

\S4method{spc.plot.time.plotly}{Spectra}(sp, column, plot.max = 10,
  showlegend = FALSE, hoverinfo = "name", title = sp@LongName)
}
\arguments{
\item{sp}{A \code{Spectra} object}

\item{column}{Number or name , defoult value is 10 if a number or name has not been entered}

\item{plot.max}{numeric value for a maximum number of data in plot}

\item{showlegend}{logical, to display legend or not, default is FALSE}

\item{hoverinfo}{a chracter, info about  \code{Spectra} object to be used  in hover box}

\item{title}{a chracter string, title for plot}
}
\description{
Plot a \code{Spectra} object with respect to time
}
\examples{
\dontrun{
sp = spc.example_spectra()
spc.plot.time.plotly(sp)
spc.plot.time.plotly(sp, plot.max = 3)
spc.plot.time.plotly(sp, c("anap_450","anap_550","anap_650"))
}

}
