% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{Spectra}
\alias{Spectra}
\title{Constructor function for the class \code{Spectra}.}
\usage{
Spectra(inDF, Spectra, Wavelengths, Units, space, time, endTime, header, ...)
}
\arguments{
\item{inDF}{a long-format \code{data.frame} containing LAT,LON and TIME columns as well as Ancillary data.
See \code{\link{stConstruct}} for more information on long DF format.}

\item{Spectra}{\code{matrix} containing spectral data. Channels are in columns, observations are in rows.
If \code{Spectra} is missing, the first \code{length(Wavelengths)} columns of inDF will be taken
as spectral data.}

\item{Wavelengths}{\code{numeric} vector containing wavelengths of spectral channels.}

\item{Units}{\code{character} defining the units of the wavelengths.}

\item{space}{a character or integer holding the 
column index in inDF where the spatial coordinates are (if length(space)==2) or where the ID of 
the spatial location is (if (length(space)==1). If \code{space} is not provided, inDF columns are
searched to match one of the following : LAT,lat,latitude,LATITUDE,LON,LONG,lon,long,longitude,LONGITUDE
If LAT & LON are not found, they set the dummy value of 1.}

\item{time}{\code{character} or \code{integer} indicating the column in inDF containing POSIXct TIME
data values. if \code{time} is missing, it is set the dummy integer sequential vector of {1:nrow(Spectra)}.}

\item{endTime}{\code{character} or \code{integer} indicating the column in inDF containing POSIXct
ENDTIME data values. If the temporal measurements are performed over an interval, \code{time} and \code{endtime} 
contain the time for the start and end of intervals respectively. If the temporal measurements are performed over 
a time-instance, then \code{endTime==TIME}. If \code{endTime} is not provided, inDF columns are searched to match 
ENDTIME. If none found, then it is assumed that data are time-instance measurements. For more information, see the
 documentation of \pkg{spacetime}.}

\item{header}{\code{SpcHeader} object containing metadata}

\item{...}{other input arguments to be passed to the new() function}
}
\value{
Returns an object of class \code{Spectra}.
}
\description{
\code{Spectra} Creates an instance of class \code{Spectra}.
}
\details{
This constructor function uses The function \code{Spectra()} calls \code{spacetime::stConstruct()}
that is the constructor  of the \code{STIDF} class using an input \code{data.frame} object of long-table format.

\code{length{@Wavelengths}==ncol(@Spectra)}. The default @WavelengthsUnit is nm^{-1}.
}
\examples{
fnm = file.path(base::system.file(package = "geoSpectral"),
"test_data","particulate_absorption.csv.gz")
fnm=gsub("\\\\\\\\", "/", fnm)
abs = read.table(fnm,sep=",",header=TRUE)
abs$STATION=factor(abs$STATION)
abs[1:2,1:17] #Display only the first 2 rows and first 17 columns if the data frame
lbd = as.numeric(gsub("X","",colnames(abs)[14:514]))
Units="1/m"
colnames(abs)= gsub("X",paste("anap","_",sep=""), colnames(abs))
colnames(abs)= gsub("PRES","DEPTH", colnames(abs))
abs = abs[,c(14:514,1:13)] #Rearrange so that Spectra columns come first
tz<-strsplit(as.character(abs$TIME)," ")[[1]][[3]] #Extract the timezone
abs$TIME = as.POSIXct(as.character(abs$TIME),tz=tz) #Compute the time

#Space and time columns are automatically found in the column names of inDF
myS<-Spectra(abs,Wavelengths=lbd,Units=Units,ShortName="a_nap")

#Space and time columns are explicitly chosen from inDF columns
myS<-Spectra(abs,Wavelengths=lbd, space=c("LONG","LAT"), time="TIME",
Units=Units,ShortName="a_nap")

}
