% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{calcFukuyamaSugeno}
\alias{calcFukuyamaSugeno}
\title{Fukuyama and Sugeno index}
\usage{
calcFukuyamaSugeno(data, belongmatrix, centers, m)
}
\arguments{
\item{data}{The original dataframe used for the clustering (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}

\item{centers}{The centers of the clusters}

\item{m}{The fuzzyness parameter}
}
\value{
A float : the Fukuyama and Sugeno index
}
\description{
Calculate Fukuyama and Sugeno index of clustering quality
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcFukuyamaSugeno(result$Data,result$Belongings, result$Centers, 1.5)
}
