% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension_add_level.R
\name{add_level}
\alias{add_level}
\alias{add_level.geodimension}
\title{Add a level to a dimension}
\usage{
add_level(gd, level = NULL)

\method{add_level}{geodimension}(gd, level = NULL)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{level}{A \code{geolevel}, level to add to the dimension.}
}
\value{
A \code{geodimension}.
}
\description{
Once a level is part of the dimension, it can then be related to other levels
of the dimension.
}
\examples{
region <-
  geolevel(name = "region",
           layer = layer_us_region,
           key = c("geoid"))

division <-
  geolevel(name = "division",
           layer = layer_us_division,
           key = c("geoid"))

gd <-
  geodimension(name = "gd_us",
               level = region) |>
  add_level(division)

}
\seealso{
Other level association functions: 
\code{\link{complete_relation_by_geography}()},
\code{\link{geodimension}()},
\code{\link{get_unrelated_instances}()},
\code{\link{relate_levels}()}
}
\concept{level association functions}
