% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sean.R
\name{sa_onrasters}
\alias{sa_onrasters}
\title{Run senstivity analysis}
\usage{
sa_onrasters(
  rast,
  global = TRUE,
  geoscale,
  link_thresholds,
  host_density_thresholds,
  agg_methods = c("sum", "mean"),
  dist_method = "geodesic",
  res = reso(),
  maps = TRUE,
  outdir = tempdir()
)
}
\arguments{
\item{rast}{Raster object which will be used in analysis.}

\item{global}{Logical. \code{TRUE} if global analysis, \code{FALSE} otherwise.
Default is \code{TRUE}}

\item{geoscale}{Vector. Geographical coordinates
in the form of c(Xmin, Xmax, Ymin, Ymax)}

\item{link_thresholds}{vector. link threshold values}

\item{host_density_thresholds}{vector. host density threshold values}

\item{agg_methods}{vector. Aggregation methods}

\item{dist_method}{character. One of the values from \code{\link[=dist_methods]{dist_methods()}}}

\item{res}{numeric.
resolution at which operations will run.
Default is \code{\link[=reso]{reso()}}}

\item{maps}{logical. \code{TRUE} if maps are to be plotted, \code{FALSE} otherwise}

\item{outdir}{Character. Output directory for saving raster in TIFF format.
Default is \code{\link[=tempdir]{tempdir()}}.}
}
\value{
A list of calculated CCRI indices after operations.
An index is generated for each combination of paramters.
One combination is equivalent to \code{\link[=sean]{sean()}} function.
}
\description{
Same as \code{\link[=sensitivity_analysis]{sensitivity_analysis()}} but it takes raster object and other parameters as an input.
}
\details{
When \code{global = TRUE}, \code{geo_scale} is ignored.
Instead uses scales from \code{\link[=global_scales]{global_scales()}}.
}
\examples{
\donttest{
rr <- get_rasters(list(monfreda = c("avocado")))
res1 <- sa_onrasters(rr[[1]],
            global = FALSE,
            geoscale = c(-115, -75, 5, 32),
            c(0.0001, 0.00004),
            c(0.0001, 0.00005),
            c("sum", "mean"),
            res = 24)
res2 <- sa_onrasters(rr[[1]],
            global = TRUE,
            link_thresholds = c(0.000001),
            host_density_thresholds = c(0.00015),
            agg_methods = c("sum"),
            res = 24)
}
}
\references{
Yanru Xing, John F Hernandez Nopsa, Kelsey F Andersen, Jorge L Andrade-Piedra, Fenton D Beed,
Guy Blomme, Mónica Carvajal-Yepes, Danny L Coyne, Wilmer J Cuellar, Gregory A Forbes,
Jan F Kreuze, Jürgen Kroschel, P Lava Kumar, James P Legg, Monica Parker, Elmar Schulte-Geldermann,
Kalpana Sharma, Karen A Garrett,
\emph{Global Cropland Connectivity: A Risk Factor for Invasion and Saturation by Emerging Pathogens and Pests},
BioScience, Volume 70, Issue 9, September 2020, Pages 744–758,
\doi{10.1093/biosci/biaa067}

Hijmans R (2023). \emph{terra: Spatial Data Analysis}.
R package version 1.7-46, \url{https://CRAN.R-project.org/package=terra}
}
\seealso{
Use \code{\link[=get_rasters]{get_rasters()}} to obtain raster object.
}
