% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-simplegeom-obj.R
\docType{class}
\name{simplegeom-class}
\alias{simplegeom-class}
\title{simplegeom class}
\description{
The \code{simplegeom} class represents geometries that can 
be coerced into polygon features. This is one of two \code{stencil} types 
accepted by \code{\link{geoknife}} (the other being \linkS4class{webgeom}).
}
\details{
The difference between \linkS4class{webgeom} and \linkS4class{simplegeom} 
is both in the permanence and the location of the data. \linkS4class{webgeom} is 
located on a web server that offers geometries using the web feature service (WFS) 
specification. \linkS4class{simplegeom} are typically local data that can be accessed 
within an R session. Within reason, anything that can be represented as a 
\linkS4class{webgeom} (or WFS) can also be represented by a \linkS4class{simplegeom} 
For example, a state or watershed can be read in as \code{\link[sp]{SpatialPolygons}} 
object and turned into a \linkS4class{simplegeom}.
}
\section{Slots}{

\describe{
\item{\code{sp}}{a \code{\link[sp]{SpatialPolygons}} object}

\item{\code{DRAW_NAMESPACE}}{(_private) web location of draw namespace}

\item{\code{DRAW_SCHEMA}}{(_private) web location of draw schema}
}}

