% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOOnlineResource.R
\docType{class}
\name{ISOOnlineResource}
\alias{ISOOnlineResource}
\title{ISOOnlineResource}
\format{\code{\link{R6Class}} object.}
\usage{
ISOOnlineResource
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Online Resource
}
\description{
ISOOnlineResource
}
\section{Fields}{

\describe{
\item{\code{linkage}}{[\code{\link{ISOURL}}] linkage}

\item{\code{protocol}}{[\code{\link{character}}] protocol}

\item{\code{name}}{[\code{\link{character}}] name}

\item{\code{description}}{[\code{\link{character}}] description}

\item{\code{function}}{[\code{\link{ISOOnLineFunction}}] online function}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOOnlineResource}}
 }
 \item{\code{setLinkage(linkage)}}{
   Sets the linkage (URL), an object of class \code{character} or \code{\link{ISOURL}}
 }
 \item{\code{setProtocol(protocol, locales)}}{
   Sets the protocol. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setName(name, locales)}}{
   Sets the name. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setDescription(description, locales)}}{
   Sets the description. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setOnLineFunction(onLineFunction)}}{
   Sets the online function, object of class \code{\link{ISOOnLineFunction}} 
   or \code{character}
 }
}
}

\examples{
  md <- ISOOnlineResource$new()
  md$setLinkage("http://somelink")
  md$setName("name")
  md$setDescription("description")
  md$setProtocol("protocol")
  md$setOnLineFunction("download")
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{online}
\keyword{resource}
