% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOAbstractCatalogue.R
\docType{class}
\name{ISOAbstractCatalogue}
\alias{ISOAbstractCatalogue}
\title{ISOAbstractCatalogue}
\format{\code{\link{R6Class}} object.}
\usage{
ISOAbstractCatalogue
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOAbstracCatalogue
}
\description{
ISOAbstractCatalogue
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{character}}]}

\item{\code{scope}}{[\code{\link{character}}]}

\item{\code{fieldOfApplication}}{[\code{\link{character}}]}

\item{\code{versionNumber}}{[\code{\link{character}}]}

\item{\code{versionDate}}{[\code{\link{character}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOAbstractCatalogue}}
 }
 \item{\code{setName(name, locales)}}{
   Sets the name. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{addScope(scope, locales)}}{
   Adds scope (object of class \code{character}). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{delScope(scope, locales)}}{
   Deletes scope. Locale names can be  specified as \code{list} with 
   the \code{locales} argument. Local names should match those of 
   the scope to be deleted, otherwise nothing will be deleted.
 }
 \item{\code{addFieldOfApplication(fieldOfApplication, locales)}}{
   Adds a field of application (object of class \code{character}). Locale names 
   can be specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{delFieldOfApplication(fieldOfApplication, locales)}}{
   Deletes fieldOfApplication. Locale names can be  specified as \code{list} with 
   the \code{locales} argument. Local names should match those of 
   the field of application to be deleted, otherwise nothing will be deleted.
 }
 \item{\code{setVersionNumber(versionNumber)}}{
   Sets version number (object of class \code{character})
 }
 \item{\code{setVersionDate(versionDate)}}{
   Sets version date
 }
}
}

\references{
ISO 19139:2007 Metadata - XML schema implementation
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{abstract}
\keyword{catalogue}
