% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFeatureType19139.R
\docType{class}
\name{ISOFeatureType19139}
\alias{ISOFeatureType19139}
\title{ISOFeatureType19139}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO FeatureType in ISO 19139
}
\description{
ISOFeatureType19139

ISOFeatureType19139
}
\examples{
 #featuretype
 md <- ISOFeatureType$new()
 md$setTypeName("typeName")
 md$setDefinition("definition")
 md$setCode("code")
 md$setIsAbstract(FALSE)
 md$addAlias("alias1")
 md$addAlias("alias2")
 
 #add feature attributes
 for(i in 1:3){
   #create attribute
   fat <- ISOFeatureAttribute$new()
   fat$setMemberName(sprintf("name \%s",i))
   fat$setDefinition(sprintf("definition \%s",i))
   fat$setCardinality(lower=1,upper=1)
   fat$setCode(sprintf("code \%s",i))
   
   #add measurement unit
   gml <- GMLBaseUnit$new(id = "ID\%")
   gml$setDescriptionReference("someref")
   gml$setIdentifier("identifier", "codespace")
   gml$addName("name1", "codespace")
   gml$addName("name2", "codespace")
   gml$setQuantityTypeReference("someref")
   gml$setCatalogSymbol("symbol")
   gml$setUnitsSystem("somelink")
   fat$setValueMeasurementUnit(gml)
   
   #add listed values
   val1 <- ISOListedValue$new()
   val1$setCode("code1")
   val1$setLabel("label1")
   val1$setDefinition("definition1")
   fat$addListedValue(val1)
   val2 <- ISOListedValue$new()
   val2$setCode("code2")
   val2$setLabel("label2")
   val2$setDefinition("definition2")
   fat$addListedValue(val2)
   fat$setValueType("typeName")
   
   #add feature attribute as carrierOfCharacteristic
   md$addCharacteristic(fat)
 }
 xml <- md$encode()
 
}
\references{
- ISO 19110 - GFC 1.0 https://schemas.isotc211.org/19110/-/gfc/1.0/gfc/#element_FC_FeatureType
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{feature}
\keyword{type}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOFeatureType]{geometa::ISOFeatureType}} -> \code{ISOFeatureType19139}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{typeName}}{typeName [1..1]: ISOLocalName or character}

\item{\code{definition}}{definition [0..1]: character}

\item{\code{code}}{code [0..1]: character}

\item{\code{isAbstract}}{isAbstract [1..1]: logical}

\item{\code{aliases}}{aliases [0..*]: ISOLocalName or character}

\item{\code{inheritsFrom}}{inheritsFrom [0..*]: ISOInheritanceRelation}

\item{\code{inheritsTo}}{inheritsTo [0..*]: ISOInheritanceRelation}

\item{\code{featureCatalogue}}{featureCatalogue: ISOFeatureCatalogue}

\item{\code{constrainedBy}}{constrainedBy [0..*]: ISOConstraint}

\item{\code{definitionReference}}{definitionReference [0..*]: ISODefinitionReference}

\item{\code{carrierOfCharacteristics}}{carrierOfCharacteristics [0..*]: ISOCarrierOfCharacteristics}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOFeatureType19139-new}{\code{ISOFeatureType19139$new()}}
\item \href{#method-ISOFeatureType19139-setTypeName}{\code{ISOFeatureType19139$setTypeName()}}
\item \href{#method-ISOFeatureType19139-setDefinition}{\code{ISOFeatureType19139$setDefinition()}}
\item \href{#method-ISOFeatureType19139-setCode}{\code{ISOFeatureType19139$setCode()}}
\item \href{#method-ISOFeatureType19139-setIsAbstract}{\code{ISOFeatureType19139$setIsAbstract()}}
\item \href{#method-ISOFeatureType19139-addAlias}{\code{ISOFeatureType19139$addAlias()}}
\item \href{#method-ISOFeatureType19139-delAlias}{\code{ISOFeatureType19139$delAlias()}}
\item \href{#method-ISOFeatureType19139-addInheritsFrom}{\code{ISOFeatureType19139$addInheritsFrom()}}
\item \href{#method-ISOFeatureType19139-delInheritsFrom}{\code{ISOFeatureType19139$delInheritsFrom()}}
\item \href{#method-ISOFeatureType19139-addInheritsTo}{\code{ISOFeatureType19139$addInheritsTo()}}
\item \href{#method-ISOFeatureType19139-delInheritsTo}{\code{ISOFeatureType19139$delInheritsTo()}}
\item \href{#method-ISOFeatureType19139-setFeatureCatalogue}{\code{ISOFeatureType19139$setFeatureCatalogue()}}
\item \href{#method-ISOFeatureType19139-addConstraint}{\code{ISOFeatureType19139$addConstraint()}}
\item \href{#method-ISOFeatureType19139-delConstraint}{\code{ISOFeatureType19139$delConstraint()}}
\item \href{#method-ISOFeatureType19139-setDefinitionReference}{\code{ISOFeatureType19139$setDefinitionReference()}}
\item \href{#method-ISOFeatureType19139-addCharacteristic}{\code{ISOFeatureType19139$addCharacteristic()}}
\item \href{#method-ISOFeatureType19139-delCharacteristic}{\code{ISOFeatureType19139$delCharacteristic()}}
\item \href{#method-ISOFeatureType19139-clone}{\code{ISOFeatureType19139$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-setTypeName"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-setTypeName}{}}}
\subsection{Method \code{setTypeName()}}{
Set type name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$setTypeName(typeName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{typeName}}{type name, object of class \link{ISOLocalName} or \link{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-setDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-setDefinition}{}}}
\subsection{Method \code{setDefinition()}}{
Set definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$setDefinition(definition, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{definition}}{definition}

\item{\code{locales}}{list of localized definitions. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-setCode"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-setCode}{}}}
\subsection{Method \code{setCode()}}{
Set code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$setCode(code, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{definition}

\item{\code{locales}}{list of localized codes. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-setIsAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-setIsAbstract}{}}}
\subsection{Method \code{setIsAbstract()}}{
Set whether feature type is abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$setIsAbstract(isAbstract)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isAbstract}}{object of class \link{logical}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-addAlias"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-addAlias}{}}}
\subsection{Method \code{addAlias()}}{
Adds alias
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$addAlias(alias)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alias}}{object of class \link{ISOLocalName} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-delAlias"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-delAlias}{}}}
\subsection{Method \code{delAlias()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$delAlias(alias)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alias}}{object of class \link{ISOLocalName} or \link{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-addInheritsFrom"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-addInheritsFrom}{}}}
\subsection{Method \code{addInheritsFrom()}}{
Adds 'inheritsFrom' relation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$addInheritsFrom(rel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rel}}{rel, object of class \link{ISOInheritanceRelation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-delInheritsFrom"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-delInheritsFrom}{}}}
\subsection{Method \code{delInheritsFrom()}}{
Deletes 'inheritsFrom' relation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$delInheritsFrom(rel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rel}}{rel, object of class \link{ISOInheritanceRelation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-addInheritsTo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-addInheritsTo}{}}}
\subsection{Method \code{addInheritsTo()}}{
Adds 'inheritsTo' relation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$addInheritsTo(rel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rel}}{rel, object of class \link{ISOInheritanceRelation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-delInheritsTo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-delInheritsTo}{}}}
\subsection{Method \code{delInheritsTo()}}{
Deletes 'inheritsTo' relation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$delInheritsTo(rel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rel}}{rel, object of class \link{ISOInheritanceRelation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-setFeatureCatalogue"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-setFeatureCatalogue}{}}}
\subsection{Method \code{setFeatureCatalogue()}}{
Set feature catalogue
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$setFeatureCatalogue(fc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fc}}{object of class \link{ISOFeatureCatalogue}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-addConstraint"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-addConstraint}{}}}
\subsection{Method \code{addConstraint()}}{
Adds constraint
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$addConstraint(constraint)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{constraint}}{constraint, object of class \link{ISOConstraint}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-delConstraint"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-delConstraint}{}}}
\subsection{Method \code{delConstraint()}}{
Deletes constraint
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$delConstraint(constraint)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{constraint}}{constraint, object of class \link{ISOConstraint}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-setDefinitionReference"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-setDefinitionReference}{}}}
\subsection{Method \code{setDefinitionReference()}}{
Set definition reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$setDefinitionReference(definitionReference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{definitionReference}}{object of class \link{ISODefinitionReference}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-addCharacteristic"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-addCharacteristic}{}}}
\subsection{Method \code{addCharacteristic()}}{
Adds characteristic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$addCharacteristic(characteristic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{characteristic}}{characteristic, object inheriting class \link{ISOAbstractCarrierOfCharacteristics}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-delCharacteristic"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-delCharacteristic}{}}}
\subsection{Method \code{delCharacteristic()}}{
Deletes characteristic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$delCharacteristic(characteristic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{characteristic}}{characteristic, object inheriting class \link{ISOAbstractCarrierOfCharacteristics}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureType19139-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureType19139-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureType19139$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
