% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExtent.R
\name{getExtent}
\alias{getExtent}
\alias{getExtent,ANY-method}
\alias{getExtent,geom-method}
\alias{getExtent,Spatial-method}
\alias{getExtent,sf-method}
\alias{getExtent,ppp-method}
\alias{getExtent,Raster-method}
\alias{getExtent,matrix-method}
\title{Get the extent (bounding box) of a spatial object.}
\usage{
\S4method{getExtent}{ANY}(x)

\S4method{getExtent}{geom}(x)

\S4method{getExtent}{Spatial}(x)

\S4method{getExtent}{sf}(x)

\S4method{getExtent}{ppp}(x)

\S4method{getExtent}{Raster}(x)

\S4method{getExtent}{matrix}(x)
}
\arguments{
\item{x}{the object from which to derive the extent.}
}
\value{
A table of the lower left and upper right corner of the extent of
  \code{x}.
}
\description{
Get the extent (bounding box) of a spatial object.
}
\examples{
getExtent(gtGeoms$polygon)

getExtent(x = gtSP$SpatialPolygons)

getExtent(x = gtSF$multilinestring)

getExtent(x = gtPPP)

getExtent(x = gtRasters$categorical)

getExtent(x = matrix(0, 3, 5))
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayer}()},
\code{\link{getName}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
