% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_sketch.R
\name{gt_sketch}
\alias{gt_sketch}
\title{Sketch \code{geom}s}
\usage{
gt_sketch(
  template = NULL,
  shape = NULL,
  features = 1,
  vertices = NULL,
  regular = FALSE,
  fixed = FALSE,
  show = FALSE,
  ...
)
}
\arguments{
\item{template}{[\code{RasterLayer(1)} | \code{matrix(1)}]\cr Gridded object
that serves as template to sketch the geometry.}

\item{shape}{[\code{character(1)}]\cr a geometry shape that should be
sketched, possible are the geom types \code{"point"}, \code{"line"} and
\code{"polygon"} and special cases thereof (recently implemented are
\code{"triangle"}, \code{"square"}, \code{"hexagon"}) and \code{"random"}.}

\item{features}{[\code{integerish(1)}]\cr number of geometries to create.}

\item{vertices}{[\code{integerish(.)}]\cr number of vertices per geometry;
will be recycled if it does not have as many elements as specified in
\code{features}.}

\item{regular}{[\code{logical(1)}]\cr if a polygon is sketched, should it be
regular, i.e. point symmetric (\code{TRUE}) with the number of corners
defined by \code{vertices} or should the vertices be selected according to
the click locations, resulting in a non-regular polygon (\code{FALSE},
default)?}

\item{fixed}{[\code{logical(1)}]\cr if a regular polygon is sketched, should
it be aligned vertically (\code{TRUE}, default), or should it be aligned
according to the second click (\code{FALSE}); only relevant if
\code{regular = TRUE}.}

\item{show}{[\code{logical(1)}]\cr should plot information be shown in the
plot (\code{TRUE}), or should the geom merely be returned in the console
(\code{FALSE, default})}

\item{...}{[various]\cr additional arguments to \code{\link{gt_locate}}.}
}
\value{
An invisible \code{geom}.
}
\description{
Sketch \code{geom}s by clicking into a plot.
}
\examples{
\donttest{
# sketch a point geometry
gt_sketch(template = gtRasters$categorical, shape = "point") \%>\%
  visualise(points = ., linecol = "green", pointsymbol = 5, new = FALSE)

# sketch a line geometry
gt_sketch(template = gtRasters$categorical, vertices = 4, shape = "line") \%>\%
  visualise(points = ., linecol = "orange", linewidth = 5, new = FALSE)

# sketch a polygon geometry
gt_sketch(template = gtRasters$continuous, shape = "hexagon") \%>\%
  visualise(geom = ., linecol = "deeppink", linetype = 2, new = FALSE)
}
}
\seealso{
Other geometry tools: 
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_scale}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
