% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGroups.R
\name{getGroups}
\alias{getGroups}
\alias{getGroups,ANY-method}
\alias{getGroups,geom-method}
\alias{getGroups,Raster-method}
\alias{getGroups,matrix-method}
\title{Get the table of group attributes}
\usage{
\S4method{getGroups}{ANY}(x, ...)

\S4method{getGroups}{geom}(x, ...)

\S4method{getGroups}{Raster}(x)

\S4method{getGroups}{matrix}(x)
}
\arguments{
\item{x}{the object from which to derive the attribute table.}

\item{...}{subset based on logical predicates defined in terms of the
columns in \code{x} or a vector of booleans. Multiple conditions are
combined with \code{&}. Only rows where the condition evaluates to TRUE are kept.}
}
\value{
A table of the group attributes of \code{x} or an object where the
  groups table has been subsetted.
}
\description{
Get tabular information of the attributes of groups of features.
}
\examples{
getGroups(x = gtGeoms$polygon)

# for raster objects, groups are pixels with the same value and their
# attributes are in the raster attribute table (RAT)
getGroups(x = gtRasters$categorical)
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getHistory}()},
\code{\link{getLayer}()},
\code{\link{getName}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
